/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestFSHLogTimedOutSync {
    private static final Log LOG = LogFactory.getLog(TestFSHLogTimedOutSync.class);
    @Rule
    public TestName name = new TestName();
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    private static final String COLUMN_QUALIFIER = "MyCQ";
    private static final byte[] COLUMN_QUALIFIER_BYTES = Bytes.toBytes((String)"MyCQ");
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration CONF;
    private String dir;
    protected TableName tableName;

    @Before
    public void setup() throws IOException {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setFloat("hfile.block.cache.size", 0.0f);
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        LOG.info((Object)("Cleaning test directory: " + TEST_UTIL.getDataTestDir()));
        TEST_UTIL.cleanupTestDir();
    }

    @Test(timeout=30000L)
    public void testRSAbortWhenSyncTimedOut() throws IOException {
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        class DodgyFSLog
        extends FSHLog {
            volatile boolean throwSyncException;

            public DodgyFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
                this.throwSyncException = false;
            }

            public void sync(long txid) throws IOException {
                super.sync(txid);
                if (this.throwSyncException) {
                    throw new TimeoutIOException("Exception");
                }
            }

            public void sync(long txid, boolean force) throws IOException {
                super.sync(txid, force);
                if (this.throwSyncException) {
                    throw new TimeoutIOException("Exception");
                }
            }
        }
        DodgyFSLog dodgyWAL = new DodgyFSLog(fs, rootDir, this.getName(), CONF);
        HRegion region = this.initHRegion(this.tableName, null, null, CONF, (WAL)dodgyWAL);
        region.setRegionServerServices(services);
        byte[] row = Bytes.toBytes((String)this.getName());
        byte[] value = Bytes.toBytes((String)this.getName());
        try {
            dodgyWAL.throwSyncException = true;
            Put put = new Put(row);
            put.addColumn(COLUMN_FAMILY_BYTES, COLUMN_QUALIFIER_BYTES, value);
            region.put(put);
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof TimeoutIOException));
        }
        ((RegionServerServices)Mockito.verify((Object)services, (VerificationMode)Mockito.times((int)1))).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
        try {
            dodgyWAL.throwSyncException = true;
            Append a = new Append(row);
            a.setReturnResults(false);
            a.add(COLUMN_FAMILY_BYTES, COLUMN_QUALIFIER_BYTES, value);
            region.append(a, 0L, 0L);
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof TimeoutIOException));
        }
        ((RegionServerServices)Mockito.verify((Object)services, (VerificationMode)Mockito.times((int)2))).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
        try {
            dodgyWAL.throwSyncException = true;
            Increment inc = new Increment(row);
            inc.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"qual2"), 1L);
            region.increment(inc, 0L, 0L);
            Assert.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof TimeoutIOException));
        }
        ((RegionServerServices)Mockito.verify((Object)services, (VerificationMode)Mockito.times((int)3))).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
    }

    String getName() {
        return this.name.getMethodName();
    }

    public HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, WAL wal) throws IOException {
        return TEST_UTIL.createLocalHRegion(tableName.getName(), startKey, stopKey, this.getName(), conf, false, Durability.SYNC_WAL, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }
}

