/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ReplicationTests.class})
public class TestReplicationSourceLogQueue {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnqueueDequeue() {
        try {
            String walGroupId1 = "fake-walgroup-id-1";
            String walGroupId2 = "fake-walgroup-id-2";
            ManualEnvironmentEdge manualEdge = new ManualEnvironmentEdge();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)manualEdge);
            MetricsSource metrics = new MetricsSource("1");
            Configuration conf = HBaseConfiguration.create();
            ReplicationSourceLogQueue logQueue = new ReplicationSourceLogQueue(conf, metrics);
            Path log1 = new Path("log-walgroup-a.8");
            manualEdge.setValue(10L);
            logQueue.enqueueLog(log1, walGroupId1);
            Assert.assertEquals((long)2L, (long)logQueue.getOldestWalAge());
            Path log2 = new Path("log-walgroup-b.4");
            logQueue.enqueueLog(log2, walGroupId2);
            Assert.assertEquals((long)6L, (long)logQueue.getOldestWalAge());
            logQueue.remove(walGroupId2);
            Assert.assertEquals((long)2L, (long)logQueue.getOldestWalAge());
            logQueue.remove(walGroupId1);
            Assert.assertEquals((long)0L, (long)logQueue.getOldestWalAge());
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }
}

