/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummyWithNoTermination;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.TestReplicationSourceManagerBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationSourceWithoutReplicationZnodes
extends TestReplicationSourceManagerBase {
    @Before
    public void removeExistingSourcesFromSourceManager() {
        manager.getSources().clear();
        manager.getOldSources().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicationSourceRunningWithoutPeerZnodes() throws Exception {
        String replicationSourceImplName = conf.get("replication.replicationsource.implementation");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        KeyValue kv = new KeyValue(r1, f1, r1);
        WALEdit edit = new WALEdit();
        edit.add((Cell)kv);
        try {
            conf.set("replication.replicationsource.implementation", ReplicationSourceDummyWithNoTermination.class.getCanonicalName());
            ArrayList<Replication> listeners = new ArrayList<Replication>();
            listeners.add(replication);
            WALFactory wals = new WALFactory(utility.getConfiguration(), listeners, URLEncoder.encode("regionserver:60020", "UTF8"));
            WAL wal = wals.getWAL(hri.getEncodedNameAsBytes(), hri.getTable().getNamespace());
            manager.init();
            long txid = wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), test, System.currentTimeMillis(), mvcc), edit, true);
            wal.sync(txid);
            wal.rollWriter();
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    return !TestReplicationSourceManagerBase.manager.getSources().isEmpty();
                }
            });
            Assert.assertEquals((String)"There should be exactly one source", (long)1L, (long)manager.getSources().size());
            Assert.assertEquals((String)"Replication source is not correct", ReplicationSourceDummyWithNoTermination.class, ((ReplicationSourceInterface)manager.getSources().get(0)).getClass());
            ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1");
            ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)("/hbase/replication/rs/" + server.getServerName() + "/1"));
            manager.logPositionAndCleanOldLogs(((ReplicationSourceInterface)manager.getSources().get(0)).getCurrentPath(), "1", 0L, false, false);
            Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    return TestReplicationSourceManagerBase.manager.getSources().isEmpty();
                }
            });
        }
        finally {
            conf.set("replication.replicationsource.implementation", replicationSourceImplName);
        }
    }
}

