/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.AuthFailingRecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.AuthFailingZooKeeper;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.SelfHealingRecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestZKAuthFailedRecovery {
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int FAILURES_BEFORE_SUCCESS = 3;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFaultyClientZK() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setClass("zookeeper.factory.class", AuthFailingZooKeeperFactory.class, ZKUtil.ZooKeeperFactory.class);
        this.LOG.debug("Reading meta first time");
        final Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        try (Table t = conn.getTable(TableName.valueOf((String)"hbase:meta"));){
            this.LOG.info(TEST_UTIL.countRows(t) + " rows in meta");
        }
        ZooKeeper zk = HConnectionTestingUtility.unwrapZK(conn).checkZk();
        Assert.assertEquals(AuthFailingZooKeeper.class, zk.getClass());
        ((AuthFailingZooKeeper)zk).triggerAuthFailed();
        HConnectionTestingUtility.clearRegionCache(conn);
        ExecutorService svc = Executors.newSingleThreadExecutor();
        Future<Boolean> res = svc.submit(new Callable<Boolean>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() {
                TestZKAuthFailedRecovery.this.LOG.debug("Reading meta after clearing the Region caches");
                try (Table t = conn.getTable(TableName.valueOf((String)"hbase:meta"));){
                    TestZKAuthFailedRecovery.this.LOG.info(TEST_UTIL.countRows(t) + " rows in meta");
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    TestZKAuthFailedRecovery.this.LOG.error("Failed to read hbase:meta", (Throwable)e);
                    return false;
                }
            }
        });
        try {
            res.get(30L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            this.LOG.error("Failed to execute task", (Throwable)e);
            Assert.fail((String)"Failed to recover from AUTH_FAILED state in zookeeper client");
        }
        catch (TimeoutException e) {
            this.LOG.error("Task timed out instead of recovering", (Throwable)e);
            Assert.fail((String)"Failed to recover from AUTH_FAILED state in zookeeper client");
        }
    }

    @Test
    public void eventuallyRecoveringZKClient() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setClass("zookeeper.factory.class", SelfHealingZooKeeperFactory.class, ZKUtil.ZooKeeperFactory.class);
        conf.setInt("hbase.zookeeper.authfailed.retries.number", 4);
        conf.setInt("hbase.zookeeper.authfailed.pause", 0);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        RecoverableZooKeeper recoverableZk = HConnectionTestingUtility.unwrapZK(conn);
        Assert.assertEquals(SelfHealingRecoverableZooKeeper.class, recoverableZk.getClass());
        ZooKeeper zk = recoverableZk.checkZk();
        Assert.assertEquals(AuthFailingZooKeeper.class, zk.getClass());
        try (Table t = conn.getTable(TableName.valueOf((String)"hbase:meta"));){
            this.LOG.info(TEST_UTIL.countRows(t) + " rows in meta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void retriesExceededOnAuthFailed() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setClass("zookeeper.factory.class", SelfHealingZooKeeperFactory.class, ZKUtil.ZooKeeperFactory.class);
        conf.setInt("hbase.zookeeper.authfailed.retries.number", 2);
        conf.setInt("hbase.zookeeper.authfailed.pause", 0);
        try (Connection conn = null;){
            conn = ConnectionFactory.createConnection((Configuration)conf);
        }
    }

    public static class SelfHealingZooKeeperFactory
    implements ZKUtil.ZooKeeperFactory {
        public RecoverableZooKeeper create(String quorumServers, int sessionTimeout, Watcher watcher, int maxRetries, int retryIntervalMillis, int maxSleepTime, String identifier, int authFailedRetries, int authFailedPause, int multiMaxSize) throws IOException {
            return new SelfHealingRecoverableZooKeeper(quorumServers, sessionTimeout, watcher, maxRetries, retryIntervalMillis, maxSleepTime, identifier, authFailedRetries, authFailedPause, 3, multiMaxSize);
        }
    }

    public static class AuthFailingZooKeeperFactory
    implements ZKUtil.ZooKeeperFactory {
        public RecoverableZooKeeper create(String quorumServers, int sessionTimeout, Watcher watcher, int maxRetries, int retryIntervalMillis, int maxSleepTime, String identifier, int authFailedRetries, int authFailedPause, int multiMaxSize) throws IOException {
            return new AuthFailingRecoverableZooKeeper(quorumServers, sessionTimeout, watcher, maxRetries, retryIntervalMillis, maxSleepTime, identifier, authFailedRetries, authFailedPause, multiMaxSize);
        }
    }
}

