/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AdaptiveLifoCoDelCallQueue;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcHandler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.util.BoundedPriorityBlockingQueue;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public abstract class RpcExecutor {
    private static final Log LOG = LogFactory.getLog(RpcExecutor.class);
    protected static final int DEFAULT_CALL_QUEUE_SIZE_HARD_LIMIT = 250;
    public static final String CALL_QUEUE_HANDLER_FACTOR_CONF_KEY = "hbase.ipc.server.callqueue.handler.factor";
    public static final String QUEUE_MAX_CALL_DELAY_CONF_KEY = "hbase.ipc.server.queue.max.call.delay";
    public static final String CALL_QUEUE_TYPE_CODEL_CONF_VALUE = "codel";
    public static final String CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE = "deadline";
    public static final String CALL_QUEUE_TYPE_FIFO_CONF_VALUE = "fifo";
    public static final String CALL_QUEUE_TYPE_CONF_KEY = "hbase.ipc.server.callqueue.type";
    public static final String CALL_QUEUE_TYPE_CONF_DEFAULT = "fifo";
    public static final String CALL_QUEUE_CODEL_TARGET_DELAY = "hbase.ipc.server.callqueue.codel.target.delay";
    public static final String CALL_QUEUE_CODEL_INTERVAL = "hbase.ipc.server.callqueue.codel.interval";
    public static final String CALL_QUEUE_CODEL_LIFO_THRESHOLD = "hbase.ipc.server.callqueue.codel.lifo.threshold";
    public static final int CALL_QUEUE_CODEL_DEFAULT_TARGET_DELAY = 100;
    public static final int CALL_QUEUE_CODEL_DEFAULT_INTERVAL = 100;
    public static final double CALL_QUEUE_CODEL_DEFAULT_LIFO_THRESHOLD = 0.8;
    private AtomicLong numGeneralCallsDropped = new AtomicLong();
    private AtomicLong numLifoModeSwitches = new AtomicLong();
    protected final int numCallQueues;
    protected final List<BlockingQueue<CallRunner>> queues;
    private final Class<? extends BlockingQueue> queueClass;
    private final Object[] queueInitArgs;
    private final PriorityFunction priority;
    protected volatile int currentQueueLimit;
    private final AtomicInteger activeHandlerCount = new AtomicInteger(0);
    private final List<RpcHandler> handlers;
    private final int handlerCount;
    private final AtomicInteger failedHandlerCount = new AtomicInteger(0);
    private String name;
    private Configuration conf = null;
    private Abortable abortable = null;
    private static QueueBalancer ONE_QUEUE = new QueueBalancer(){

        @Override
        public int getNextQueue() {
            return 0;
        }
    };

    @Deprecated
    public RpcExecutor(String name, int handlerCount, int numCallQueues) {
        this.name = Strings.nullToEmpty((String)name);
        this.handlers = new ArrayList<RpcHandler>(handlerCount);
        this.handlerCount = handlerCount;
        this.numCallQueues = numCallQueues;
        this.queues = new ArrayList<BlockingQueue<CallRunner>>(this.numCallQueues);
        this.queueClass = null;
        this.queueInitArgs = new Object[0];
        this.priority = null;
    }

    @Deprecated
    public RpcExecutor(String name, int handlerCount, int numCallQueues, Configuration conf, Abortable abortable) {
        this(name, handlerCount, numCallQueues);
        this.conf = conf;
        this.abortable = abortable;
    }

    public RpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this(name, handlerCount, conf.get(CALL_QUEUE_TYPE_CONF_KEY, "fifo"), maxQueueLength, priority, conf, abortable);
    }

    public RpcExecutor(String name, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this.name = Strings.nullToEmpty((String)name);
        this.conf = conf;
        this.abortable = abortable;
        float callQueuesHandlersFactor = this.conf.getFloat(CALL_QUEUE_HANDLER_FACTOR_CONF_KEY, 0.0f);
        if (Float.compare(callQueuesHandlersFactor, 1.0f) > 0 || Float.compare(0.0f, callQueuesHandlersFactor) > 0) {
            LOG.warn((Object)"hbase.ipc.server.callqueue.handler.factor is *ILLEGAL*, it should be in range [0.0, 1.0]");
            if (Float.compare(callQueuesHandlersFactor, 1.0f) > 0) {
                LOG.warn((Object)"Set hbase.ipc.server.callqueue.handler.factor 1.0f");
                callQueuesHandlersFactor = 1.0f;
            } else {
                LOG.warn((Object)"Set hbase.ipc.server.callqueue.handler.factor default value 0.0f");
            }
        }
        this.numCallQueues = this.computeNumCallQueues(handlerCount, callQueuesHandlersFactor);
        this.queues = new ArrayList<BlockingQueue<CallRunner>>(this.numCallQueues);
        this.handlerCount = Math.max(handlerCount, this.numCallQueues);
        this.handlers = new ArrayList<RpcHandler>(this.handlerCount);
        this.priority = priority;
        if (RpcExecutor.isDeadlineQueueType(callQueueType)) {
            this.name = this.name + ".Deadline";
            this.queueInitArgs = new Object[]{maxQueueLength, new CallPriorityComparator(conf, this.priority)};
            this.queueClass = BoundedPriorityBlockingQueue.class;
        } else if (RpcExecutor.isCodelQueueType(callQueueType)) {
            this.name = this.name + ".Codel";
            int codelTargetDelay = conf.getInt(CALL_QUEUE_CODEL_TARGET_DELAY, 100);
            int codelInterval = conf.getInt(CALL_QUEUE_CODEL_INTERVAL, 100);
            double codelLifoThreshold = conf.getDouble(CALL_QUEUE_CODEL_LIFO_THRESHOLD, 0.8);
            this.queueInitArgs = new Object[]{maxQueueLength, codelTargetDelay, codelInterval, codelLifoThreshold, this.numGeneralCallsDropped, this.numLifoModeSwitches};
            this.queueClass = AdaptiveLifoCoDelCallQueue.class;
        } else {
            this.name = this.name + ".Fifo";
            this.queueInitArgs = new Object[]{maxQueueLength};
            this.queueClass = LinkedBlockingQueue.class;
        }
        LOG.info((Object)("RpcExecutor  name  using " + callQueueType + " as call queue; numCallQueues=" + this.numCallQueues + "; maxQueueLength=" + maxQueueLength + "; handlerCount=" + handlerCount));
    }

    protected int computeNumCallQueues(int handlerCount, float callQueuesHandlersFactor) {
        return Math.max(1, Math.round((float)handlerCount * callQueuesHandlersFactor));
    }

    protected void initializeQueues(int numQueues) {
        if (this.queueInitArgs.length > 0) {
            this.currentQueueLimit = (Integer)this.queueInitArgs[0];
            this.queueInitArgs[0] = Math.max((Integer)this.queueInitArgs[0], 250);
        }
        for (int i = 0; i < numQueues; ++i) {
            this.queues.add((BlockingQueue)ReflectionUtils.newInstance(this.queueClass, (Object[])this.queueInitArgs));
        }
    }

    public void start(int port) {
        this.startHandlers(port);
    }

    public void stop() {
        for (RpcHandler handler : this.handlers) {
            handler.stopRunning();
            handler.interrupt();
        }
    }

    public abstract boolean dispatch(CallRunner var1) throws InterruptedException;

    public List<BlockingQueue<CallRunner>> getQueues() {
        return this.queues;
    }

    protected void startHandlers(int port) {
        List<BlockingQueue<CallRunner>> callQueues = this.getQueues();
        this.startHandlers(null, this.handlerCount, callQueues, 0, callQueues.size(), port, this.activeHandlerCount);
    }

    protected RpcHandler getHandler(String name, double handlerFailureThreshhold, int handlerCount, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount, AtomicInteger failedHandlerCount, Abortable abortable) {
        return new RpcHandler(name, handlerFailureThreshhold, handlerCount, q, activeHandlerCount, failedHandlerCount, abortable);
    }

    protected void startHandlers(String nameSuffix, int numHandlers, List<BlockingQueue<CallRunner>> callQueues, int qindex, int qsize, int port, AtomicInteger activeHandlerCount) {
        String threadPrefix = this.name + Strings.nullToEmpty((String)nameSuffix);
        double handlerFailureThreshhold = this.conf == null ? 1.0 : this.conf.getDouble("hbase.regionserver.handler.abort.on.error.percent", 0.5);
        for (int i = 0; i < numHandlers; ++i) {
            int index = qindex + i % qsize;
            String name = "RpcServer." + threadPrefix + ".handler=" + this.handlers.size() + ",queue=" + index + ",port=" + port;
            RpcHandler handler = this.getHandler(name, handlerFailureThreshhold, this.handlerCount, callQueues.get(index), activeHandlerCount, this.failedHandlerCount, this.abortable);
            handler.start();
            LOG.debug((Object)("Started " + name));
            this.handlers.add(handler);
        }
    }

    public static QueueBalancer getBalancer(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0, (Object)"Queue size is <= 0, must be at least 1");
        if (queueSize == 1) {
            return ONE_QUEUE;
        }
        return new RandomQueueBalancer(queueSize);
    }

    public static boolean isDeadlineQueueType(String callQueueType) {
        return callQueueType.equals(CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE);
    }

    public static boolean isCodelQueueType(String callQueueType) {
        return callQueueType.equals(CALL_QUEUE_TYPE_CODEL_CONF_VALUE);
    }

    public static boolean isFifoQueueType(String callQueueType) {
        return callQueueType.equals("fifo");
    }

    public long getNumGeneralCallsDropped() {
        return this.numGeneralCallsDropped.get();
    }

    public long getNumLifoModeSwitches() {
        return this.numLifoModeSwitches.get();
    }

    public int getActiveHandlerCount() {
        return this.activeHandlerCount.get();
    }

    public int getActiveWriteHandlerCount() {
        return 0;
    }

    public int getActiveReadHandlerCount() {
        return 0;
    }

    public int getActiveScanHandlerCount() {
        return 0;
    }

    public int getQueueLength() {
        int length = 0;
        for (BlockingQueue<CallRunner> queue : this.queues) {
            length += queue.size();
        }
        return length;
    }

    public int getReadQueueLength() {
        return 0;
    }

    public int getScanQueueLength() {
        return 0;
    }

    public int getWriteQueueLength() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void resizeQueues(Configuration conf) {
        String configKey = "hbase.ipc.server.max.callqueue.length";
        if (this.name != null && this.name.toLowerCase(Locale.ROOT).contains("priority")) {
            configKey = "hbase.ipc.server.priority.max.callqueue.length";
        }
        this.currentQueueLimit = conf.getInt(configKey, this.currentQueueLimit);
    }

    public void onConfigurationChange(Configuration conf) {
        int codelTargetDelay = conf.getInt(CALL_QUEUE_CODEL_TARGET_DELAY, 100);
        int codelInterval = conf.getInt(CALL_QUEUE_CODEL_INTERVAL, 100);
        double codelLifoThreshold = conf.getDouble(CALL_QUEUE_CODEL_LIFO_THRESHOLD, 0.8);
        for (BlockingQueue<CallRunner> queue : this.queues) {
            if (!(queue instanceof AdaptiveLifoCoDelCallQueue)) continue;
            ((AdaptiveLifoCoDelCallQueue)queue).updateTunables(codelTargetDelay, codelInterval, codelLifoThreshold);
        }
    }

    private static class CallPriorityComparator
    implements Comparator<CallRunner> {
        private static final int DEFAULT_MAX_CALL_DELAY = 5000;
        private final PriorityFunction priority;
        private final int maxDelay;

        public CallPriorityComparator(Configuration conf, PriorityFunction priority) {
            this.priority = priority;
            this.maxDelay = conf.getInt(RpcExecutor.QUEUE_MAX_CALL_DELAY_CONF_KEY, 5000);
        }

        @Override
        public int compare(CallRunner a, CallRunner b) {
            RpcServer.Call callA = a.getCall();
            RpcServer.Call callB = b.getCall();
            long deadlineA = this.priority.getDeadline(callA.getHeader(), callA.param);
            long deadlineB = this.priority.getDeadline(callB.getHeader(), callB.param);
            deadlineA = callA.timestamp + Math.min(deadlineA, (long)this.maxDelay);
            deadlineB = callB.timestamp + Math.min(deadlineB, (long)this.maxDelay);
            return Long.compare(deadlineA, deadlineB);
        }
    }

    private static class RandomQueueBalancer
    extends QueueBalancer {
        private final int queueSize;

        public RandomQueueBalancer(int queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public int getNextQueue() {
            return ThreadLocalRandom.current().nextInt(this.queueSize);
        }
    }

    public static abstract class QueueBalancer {
        public abstract int getNextQueue();
    }
}

