/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.SizedCellScanner;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
public class ReplicationProtbufUtil {
    public static void replicateWALEntry(AdminProtos.AdminService.BlockingInterface admin, WAL.Entry[] entries, String replicationClusterId, Path sourceBaseNamespaceDir, Path sourceHFileArchiveDir) throws IOException {
        Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> p = ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries, null, replicationClusterId, sourceBaseNamespaceDir, sourceHFileArchiveDir);
        HBaseRpcControllerImpl controller = new HBaseRpcControllerImpl((CellScanner)p.getSecond());
        try {
            admin.replicateWALEntry((RpcController)controller, (AdminProtos.ReplicateWALEntryRequest)p.getFirst());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getServiceException((ServiceException)se);
        }
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(WAL.Entry[] entries) throws IOException {
        return ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries, null, null, null, null);
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(WAL.Entry[] entries, byte[] encodedRegionName, String replicationClusterId, Path sourceBaseNamespaceDir, Path sourceHFileArchiveDir) throws IOException {
        ArrayList<List<? extends Cell>> allCells = new ArrayList<List<? extends Cell>>(entries.length);
        int size = 0;
        AdminProtos.WALEntry.Builder entryBuilder = AdminProtos.WALEntry.newBuilder();
        AdminProtos.ReplicateWALEntryRequest.Builder builder = AdminProtos.ReplicateWALEntryRequest.newBuilder();
        for (WAL.Entry entry : entries) {
            WALProtos.WALKey.Builder keyBuilder;
            entryBuilder.clear();
            WALKey key = entry.getKey();
            try {
                keyBuilder = key.getBuilder(WALCellCodec.getNoneCompressor());
            }
            catch (IOException e) {
                throw new IOException("There should not throw exception since NoneCompressor do not throw any exceptions", e);
            }
            if (encodedRegionName != null) {
                keyBuilder.setEncodedRegionName(ByteStringer.wrap((byte[])encodedRegionName));
            }
            entryBuilder.setKey(keyBuilder.build());
            WALEdit edit = entry.getEdit();
            ArrayList<Cell> cells = edit.getCells();
            for (Cell cell : cells) {
                size += CellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            allCells.add(cells);
            entryBuilder.setAssociatedCellCount(cells.size());
            builder.addEntry(entryBuilder.build());
        }
        if (replicationClusterId != null) {
            builder.setReplicationClusterId(replicationClusterId);
        }
        if (sourceBaseNamespaceDir != null) {
            builder.setSourceBaseNamespaceDirPath(sourceBaseNamespaceDir.toString());
        }
        if (sourceHFileArchiveDir != null) {
            builder.setSourceHFileArchiveDirPath(sourceHFileArchiveDir.toString());
        }
        return new Pair((Object)builder.build(), (Object)ReplicationProtbufUtil.getCellScanner(allCells, size));
    }

    static CellScanner getCellScanner(final List<List<? extends Cell>> cells, final int size) {
        return new SizedCellScanner(){
            private final Iterator<List<? extends Cell>> entries;
            private Iterator<? extends Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = cells.iterator();
                this.currentIterator = null;
            }

            public Cell current() {
                return this.currentCell;
            }

            public boolean advance() {
                if (this.currentIterator == null) {
                    if (!this.entries.hasNext()) {
                        return false;
                    }
                    this.currentIterator = this.entries.next().iterator();
                }
                if (this.currentIterator.hasNext()) {
                    this.currentCell = this.currentIterator.next();
                    return true;
                }
                this.currentCell = null;
                this.currentIterator = null;
                return this.advance();
            }

            public long heapSize() {
                return size;
            }
        };
    }
}

