/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.common.base.Predicate;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class ScopeWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        NavigableMap<byte[], Integer> scopes = entry.getKey().getScopes();
        if (scopes == null || scopes.isEmpty()) {
            return null;
        }
        return entry;
    }

    @Override
    public Cell filterCell(WAL.Entry entry, Cell cell) {
        final NavigableMap<byte[], Integer> scopes = entry.getKey().getScopes();
        byte[] fam = CellUtil.cloneFamily((Cell)cell);
        if (CellUtil.matchingColumn((Cell)cell, (byte[])WALEdit.METAFAMILY, (byte[])WALEdit.BULK_LOAD)) {
            cell = this.bulkLoadFilter.filterCell(cell, new Predicate<byte[]>(){

                public boolean apply(byte[] fam) {
                    return !scopes.containsKey(fam) || (Integer)scopes.get(fam) == 0;
                }
            });
        } else if (!scopes.containsKey(fam) || (Integer)scopes.get(fam) == 0) {
            return null;
        }
        return cell;
    }
}

