/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationLogCleaner
extends BaseLogCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(ReplicationLogCleaner.class);
    private ZooKeeperWatcher zkw = null;
    private ReplicationQueuesClient replicationQueues;
    private boolean stopped = false;
    private MasterServices master;
    private boolean shareZK = false;

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Set<String> wals;
        if (this.getConf() == null) {
            return files;
        }
        try {
            wals = this.loadWALsFromQueues();
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed to read zookeeper, skipping checking deletable files", (Throwable)e);
            return Collections.emptyList();
        }
        return Iterables.filter(files, (Predicate)new Predicate<FileStatus>(){

            public boolean apply(FileStatus file) {
                String wal = file.getPath().getName();
                boolean logInReplicationQueue = wals.contains(wal);
                if (LOG.isDebugEnabled()) {
                    if (logInReplicationQueue) {
                        LOG.debug((Object)("Found log in ZK, keeping: " + wal));
                    } else {
                        LOG.debug((Object)("Didn't find this log in ZK, deleting: " + wal));
                    }
                }
                return !logInReplicationQueue;
            }
        });
    }

    private Set<String> loadWALsFromQueues() throws KeeperException {
        int retry = 0;
        while (true) {
            int v0 = this.replicationQueues.getQueuesZNodeCversion();
            List rss = this.replicationQueues.getListOfReplicators();
            if (rss == null || rss.isEmpty()) {
                LOG.debug((Object)"Didn't find any region server that replicates, won't prevent any deletions.");
                return ImmutableSet.of();
            }
            Map rsToCversionBefore = this.replicationQueues.getReplicatorsZNodeCversion();
            HashSet wals = Sets.newHashSet();
            for (String rs : rss) {
                List listOfPeers = this.replicationQueues.getAllQueues(rs);
                if (listOfPeers == null) continue;
                for (String id : listOfPeers) {
                    List peersWals = this.replicationQueues.getLogsInQueue(rs, id);
                    if (peersWals == null) continue;
                    wals.addAll(peersWals);
                }
            }
            int v1 = this.replicationQueues.getQueuesZNodeCversion();
            Map rsToCversionAfter = this.replicationQueues.getReplicatorsZNodeCversion();
            if (v0 == v1 && rsToCversionBefore.equals(rsToCversionAfter)) {
                return wals;
            }
            LOG.info((Object)String.format("Replication queue node cversion changed from %d to %d, retry = %d", v0, v1, retry));
            ++retry;
        }
    }

    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication", true)) {
            LOG.warn((Object)"Not configured - allowing all wals to be deleted");
            return;
        }
        super.setConf(config);
    }

    @Override
    public void init(Map<String, Object> params) {
        Object master;
        if (this.getConf() == null) {
            return;
        }
        if (MapUtils.isNotEmpty(params) && (master = params.get("master")) != null && master instanceof HMaster) {
            this.master = (HMaster)master;
            this.zkw = ((HMaster)master).getZooKeeper();
            this.shareZK = true;
        }
        this.init(this.getConf(), this.zkw, null);
    }

    @InterfaceAudience.Private
    public void init(Configuration conf, ZooKeeperWatcher zk, ReplicationQueuesClient replicationQueuesClient) {
        super.setConf(conf);
        try {
            this.zkw = zk != null ? zk : new ZooKeeperWatcher(this.getConf(), "replicationLogCleaner", null);
            Preconditions.checkNotNull((Object)this.zkw, (Object)"Zookeeper watcher cannot be null");
            if (replicationQueuesClient != null) {
                this.replicationQueues = replicationQueuesClient;
            } else {
                this.replicationQueues = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)this.zkw, (Configuration)this.getConf(), (Abortable)this.master);
                this.replicationQueues.init();
            }
            Preconditions.checkNotNull((Object)this.replicationQueues, (Object)"ReplicationQueues cannot be null");
        }
        catch (IOException | ReplicationException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), e);
        }
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (!this.shareZK && this.zkw != null) {
            LOG.info((Object)("Stopping " + this.zkw));
            this.zkw.close();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

