/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Throwables;

final class SimpleScanResultConsumer
implements ScanResultConsumer {
    private ScanMetrics scanMetrics;
    private final List<Result> results = new ArrayList<Result>();
    private Throwable error;
    private boolean finished = false;

    SimpleScanResultConsumer() {
    }

    public void onScanMetricsCreated(ScanMetrics scanMetrics) {
        this.scanMetrics = scanMetrics;
    }

    public synchronized boolean onNext(Result result) {
        this.results.add(result);
        return true;
    }

    public synchronized void onError(Throwable error) {
        this.error = error;
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void onComplete() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized List<Result> getAll() throws Exception {
        while (!this.finished) {
            this.wait();
        }
        if (this.error != null) {
            Throwables.propagateIfPossible((Throwable)this.error, Exception.class);
            throw new Exception(this.error);
        }
        return this.results;
    }

    public ScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }
}

