/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncAdminBuilder {
    private static final Log LOG = LogFactory.getLog(TestAsyncAdminBuilder.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static AsyncConnection ASYNC_CONN;
    @Parameterized.Parameter
    public Supplier<AsyncAdminBuilder> getAdminBuilder;
    private static final int DEFAULT_RPC_TIMEOUT = 10000;
    private static final int DEFAULT_OPERATION_TIMEOUT = 30000;
    private static final int DEFAULT_RETRIES_NUMBER = 2;

    private static AsyncAdminBuilder getRawAsyncAdminBuilder() {
        return ASYNC_CONN.getAdminBuilder();
    }

    private static AsyncAdminBuilder getAsyncAdminBuilder() {
        return ASYNC_CONN.getAdminBuilder((ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({TestAsyncAdminBuilder::getRawAsyncAdminBuilder}, {TestAsyncAdminBuilder::getAsyncAdminBuilder});
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 30000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)ASYNC_CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRpcTimeout() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", TestRpcTimeoutCoprocessor.class.getName());
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        try {
            this.getAdminBuilder.get().setRpcTimeout(5000L, TimeUnit.MILLISECONDS).build().getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).get();
            Assert.fail((String)"We expect an exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getAdminBuilder.get().setRpcTimeout(20000L, TimeUnit.MILLISECONDS).build().getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).get();
        }
        catch (Exception e) {
            Assert.fail((String)("The Operation should succeed, unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testOperationTimeout() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 100);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", TestOperationTimeoutCoprocessor.class.getName());
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        try {
            this.getAdminBuilder.get().setOperationTimeout(15000L, TimeUnit.MILLISECONDS).build().getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).get();
            Assert.fail((String)"We expect an exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getAdminBuilder.get().setOperationTimeout(60000L, TimeUnit.MILLISECONDS).build().getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).get();
        }
        catch (Exception e) {
            Assert.fail((String)("The Operation should succeed, unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testMaxRetries() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 300000);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", TestMaxRetriesCoprocessor.class.getName());
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        try {
            this.getAdminBuilder.get().setMaxRetries(1).build().getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).get();
            Assert.fail((String)"We expect an exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getAdminBuilder.get().setMaxRetries(4).build().getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).get();
        }
        catch (Exception e) {
            Assert.fail((String)("The Operation should succeed, unexpected exception: " + e.getMessage()));
        }
    }

    public static class TestMaxRetriesCoprocessor
    implements MasterCoprocessor,
    MasterObserver {
        AtomicLong retryNum = new AtomicLong(0L);

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
            if (this.retryNum.getAndIncrement() < 2L) {
                throw new IOException("call fail");
            }
        }
    }

    public static class TestOperationTimeoutCoprocessor
    implements MasterCoprocessor,
    MasterObserver {
        AtomicLong sleepTime = new AtomicLong(0L);

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
            Threads.sleep((long)5000L);
            if (this.sleepTime.addAndGet(5000L) < 30000L) {
                throw new IOException("call fail");
            }
        }
    }

    public static class TestRpcTimeoutCoprocessor
    implements MasterCoprocessor,
    MasterObserver {
        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
            Threads.sleep((long)10000L);
        }
    }
}

