/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncNonMetaRegionLocatorConcurrenyLimit {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static AsyncConnectionImpl CONN;
    private static AsyncNonMetaRegionLocator LOCATOR;
    private static byte[][] SPLIT_KEYS;
    private static int MAX_ALLOWED;
    private static AtomicInteger CONCURRENCY;
    private static AtomicInteger MAX_CONCURRENCY;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", CountingRegionObserver.class.getName());
        conf.setInt("hbase.client.meta.max.concurrent.locate.per.table", MAX_ALLOWED);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getAdmin().setBalancerRunning(false, true);
        AsyncRegistry registry = AsyncRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        CONN = new AsyncConnectionImpl(TEST_UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent());
        LOCATOR = new AsyncNonMetaRegionLocator(CONN);
        SPLIT_KEYS = (byte[][])IntStream.range(1, 256).mapToObj(i -> Bytes.toBytes((String)String.format("%02x", i))).toArray(x$0 -> new byte[x$0][]);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, SPLIT_KEYS);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    private void assertLocs(List<CompletableFuture<HRegionLocation>> futures) throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)256L, (long)futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            HRegionLocation loc = futures.get(i).get();
            if (i == 0) {
                Assert.assertTrue((boolean)ConnectionUtils.isEmptyStartRow((byte[])loc.getRegionInfo().getStartKey()));
            } else {
                Assert.assertEquals((Object)String.format("%02x", i), (Object)Bytes.toString((byte[])loc.getRegionInfo().getStartKey()));
            }
            if (i == futures.size() - 1) {
                Assert.assertTrue((boolean)ConnectionUtils.isEmptyStopRow((byte[])loc.getRegionInfo().getEndKey()));
                continue;
            }
            Assert.assertEquals((Object)String.format("%02x", i + 1), (Object)Bytes.toString((byte[])loc.getRegionInfo().getEndKey()));
        }
    }

    @Test
    public void test() throws InterruptedException, ExecutionException {
        List<CompletableFuture<HRegionLocation>> futures = IntStream.range(0, 256).mapToObj(i -> Bytes.toBytes((String)String.format("%02x", i))).map(r -> LOCATOR.getRegionLocation(TABLE_NAME, r, RegionLocateType.CURRENT, false)).collect(Collectors.toList());
        this.assertLocs(futures);
        Assert.assertTrue((MAX_CONCURRENCY.get() <= MAX_ALLOWED ? 1 : 0) != 0);
    }

    static {
        MAX_ALLOWED = 2;
        CONCURRENCY = new AtomicInteger(0);
        MAX_CONCURRENCY = new AtomicInteger(0);
    }

    public static final class CountingRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().isMetaRegion()) {
                int max;
                int concurrency = CONCURRENCY.incrementAndGet();
                while (concurrency > (max = MAX_CONCURRENCY.get()) && !MAX_CONCURRENCY.compareAndSet(max, concurrency)) {
                }
                Threads.sleepWithoutInterrupt((long)10L);
            }
        }

        public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s) throws IOException {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().isMetaRegion()) {
                CONCURRENCY.decrementAndGet();
            }
        }
    }
}

