/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableAdminApi
extends TestAsyncAdminBase {
    @Test
    public void testTableExist() throws Exception {
        boolean exist = (Boolean)this.admin.tableExists(this.tableName).get();
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(this.tableName, FAMILY);
        exist = (Boolean)this.admin.tableExists(this.tableName).get();
        Assert.assertEquals((Object)true, (Object)exist);
        exist = (Boolean)this.admin.tableExists(TableName.META_TABLE_NAME).get();
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test
    public void testListTables() throws Exception {
        int i;
        int numTables = ((List)this.admin.listTables().get()).size();
        TableName tableName1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "2"));
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "3"));
        TableName[] tables = new TableName[]{tableName1, tableName2, tableName3};
        for (int i2 = 0; i2 < tables.length; ++i2) {
            this.createTableWithDefaultConf(tables[i2]);
        }
        List tableDescs = (List)this.admin.listTables().get();
        int size = tableDescs.size();
        Assert.assertTrue((size >= tables.length ? 1 : 0) != 0);
        for (int i3 = 0; i3 < tables.length && i3 < size; ++i3) {
            boolean found = false;
            for (int j = 0; j < size; ++j) {
                if (!((TableDescriptor)tableDescs.get(j)).getTableName().equals((Object)tables[i3])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + tables[i3]), (boolean)found);
        }
        List tableNames = (List)this.admin.listTableNames().get();
        size = tableNames.size();
        Assert.assertTrue((size == numTables + tables.length ? 1 : 0) != 0);
        for (i = 0; i < tables.length && i < size; ++i) {
            boolean found = false;
            for (int j = 0; j < size; ++j) {
                if (!((TableName)tableNames.get(j)).equals((Object)tables[i])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + tables[i]), (boolean)found);
        }
        for (i = 0; i < tables.length; ++i) {
            this.admin.disableTable(tables[i]).join();
            this.admin.deleteTable(tables[i]).join();
        }
        tableDescs = (List)this.admin.listTables(Optional.empty(), true).get();
        Assert.assertTrue((String)"Not found system tables", (tableDescs.size() > 0 ? 1 : 0) != 0);
        tableNames = (List)this.admin.listTableNames(Optional.empty(), true).get();
        Assert.assertTrue((String)"Not found system tables", (tableNames.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTableDescriptor() throws Exception {
        byte[][] families = new byte[][]{FAMILY, FAMILY_0, FAMILY_1};
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        for (byte[] family : families) {
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        TableDescriptor desc = builder.build();
        this.admin.createTable(desc).join();
        TableDescriptorBuilder.ModifyableTableDescriptor modifyableDesc = (TableDescriptorBuilder.ModifyableTableDescriptor)desc;
        TableDescriptor confirmedHtd = (TableDescriptor)this.admin.getTableDescriptor(this.tableName).get();
        Assert.assertEquals((long)modifyableDesc.compareTo((TableDescriptorBuilder.ModifyableTableDescriptor)confirmedHtd), (long)0L);
    }

    @Test
    public void testCreateTable() throws Exception {
        List tables = (List)this.admin.listTables().get();
        int numTables = tables.size();
        this.createTableWithDefaultConf(this.tableName);
        tables = (List)this.admin.listTables().get();
        Assert.assertEquals((long)(numTables + 1), (long)tables.size());
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(this.tableName, new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(this.tableName));
    }

    private TableState.State getStateFromMeta(TableName table) throws Exception {
        Optional state = (Optional)AsyncMetaTableAccessor.getTableState((RawAsyncTable)ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME), (TableName)table).get();
        Assert.assertTrue((boolean)state.isPresent());
        return ((TableState)state.get()).getState();
    }

    @Test
    public void testCreateTableNumberOfRegions() throws Exception {
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        this.createTableWithDefaultConf(this.tableName);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regionLocations.size());
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        this.createTableWithDefaultConf(tableName2, Optional.of(new byte[][]{{42}}));
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName2)).get();
        Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regionLocations.size());
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_3"));
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName3);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), "a".getBytes(), "z".getBytes(), 3).join();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName3)).get();
        Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regionLocations.size());
        TableName tableName4 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_4"));
        builder = TableDescriptorBuilder.newBuilder((TableName)tableName4);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        try {
            this.admin.createTable(builder.build(), "a".getBytes(), "z".getBytes(), 2).join();
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        TableName tableName5 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_5"));
        builder = TableDescriptorBuilder.newBuilder((TableName)tableName5);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), new byte[]{1}, new byte[]{127}, 16).join();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName5)).get();
        Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regionLocations.size());
    }

    @Test
    public void testCreateTableWithRegions() throws Exception {
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        this.createTableWithDefaultConf(this.tableName, Optional.of(splitKeys));
        boolean tableAvailable = (Boolean)this.admin.isTableAvailable(this.tableName, (byte[][])splitKeys).get();
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        List regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Iterator hris = regions.iterator();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.iterator();
        HRegionInfo hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        if (tablesOnMaster) {
            this.verifyRoundRobinDistribution(regions, expectedRegions);
        }
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName2);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), startKey, endKey, expectedRegions).join();
        regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName2)).get();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.iterator();
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = ((HRegionLocation)hris.next()).getRegionInfo();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        if (tablesOnMaster) {
            this.verifyRoundRobinDistribution(regions, expectedRegions);
        }
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_3"));
        builder = TableDescriptorBuilder.newBuilder((TableName)tableName3);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        this.admin.createTable(builder.build(), startKey, endKey, expectedRegions).join();
        regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName3)).get();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        if (tablesOnMaster) {
            this.verifyRoundRobinDistribution(regions, expectedRegions);
        }
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        TableName tableName4 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_4"));
        try {
            this.createTableWithDefaultConf(tableName4, Optional.of(splitKeys));
            Assert.fail((String)"Should not be able to create this table because of duplicate split keys");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    private void verifyRoundRobinDistribution(List<HRegionLocation> regions, int expectedRegions) throws IOException {
        int numRS = ((ClusterConnection)TEST_UTIL.getConnection()).getCurrentNrHRS();
        HashMap server2Regions = new HashMap();
        regions.stream().forEach(loc -> {
            ServerName server = loc.getServerName();
            server2Regions.computeIfAbsent(server, s -> new ArrayList()).add(loc.getRegionInfo());
        });
        if (numRS >= 2) {
            --numRS;
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        server2Regions.values().forEach(regionList -> Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0));
    }

    @Test
    public void testCreateTableWithOnlyEmptyStartRow() throws Exception {
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        try {
            this.createTableWithDefaultConf(this.tableName, Optional.of(splitKeys));
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws Exception {
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        try {
            this.createTableWithDefaultConf(this.tableName, Optional.of(splitKeys));
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        Assert.assertTrue((boolean)((Boolean)this.admin.tableExists(this.tableName).get()));
        TEST_UTIL.getAdmin().disableTable(this.tableName);
        this.admin.deleteTable(this.tableName).join();
        Assert.assertFalse((boolean)((Boolean)this.admin.tableExists(this.tableName).get()));
    }

    @Test
    public void testTruncateTable() throws Exception {
        this.testTruncateTable(this.tableName, false);
    }

    @Test
    public void testTruncateTablePreservingSplits() throws Exception {
        this.testTruncateTable(this.tableName, true);
    }

    private void testTruncateTable(TableName tableName, boolean preserveSplits) throws Exception {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        this.createTableWithDefaultConf(tableName, Optional.of(splitKeys));
        RawAsyncTable table = ASYNC_CONN.getRawTable(tableName);
        int expectedRows = 10;
        for (int i = 0; i < expectedRows; ++i) {
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Put put = new Put(data);
            put.addColumn(FAMILY, null, data);
            table.put(put).join();
        }
        Assert.assertEquals((long)10L, (long)((List)table.scanAll(new Scan()).get()).size());
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        this.admin.disableTable(tableName).join();
        this.admin.truncateTable(tableName, preserveSplits).join();
        Assert.assertEquals((long)0L, (long)((List)table.scanAll(new Scan()).get()).size());
        if (preserveSplits) {
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        }
    }

    @Test
    public void testDisableAndEnableTable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        RawAsyncTable table = ASYNC_CONN.getRawTable(this.tableName);
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, value);
        table.put(put).join();
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        table.get(get).get();
        this.admin.disableTable(this.tableName).join();
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(this.tableName, new TableState.State[]{TableState.State.DISABLED}));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(this.tableName));
        get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        boolean ok = false;
        try {
            table.get(get).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        ok = false;
        try {
            table.scanAll(new Scan()).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(this.tableName).join();
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(this.tableName, new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(this.tableName));
        try {
            table.get(get).get();
        }
        catch (Exception e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testDisableAndEnableTables() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "2"));
        this.createTableWithDefaultConf(tableName1);
        this.createTableWithDefaultConf(tableName2);
        RawAsyncTable table1 = ASYNC_CONN.getRawTable(tableName1);
        RawAsyncTable table2 = ASYNC_CONN.getRawTable(tableName1);
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, value);
        table1.put(put).join();
        table2.put(put).join();
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        table1.get(get).get();
        table2.get(get).get();
        ((List)this.admin.listTableNames(Optional.of(Pattern.compile(this.tableName.getNameAsString() + ".*")), false).get()).forEach(t -> {
            Void cfr_ignored_0 = (Void)this.admin.disableTable(t).join();
        });
        get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        boolean ok = false;
        try {
            table1.get(get).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        ok = false;
        try {
            table2.get(get).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(tableName1));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(tableName2));
        ((List)this.admin.listTableNames(Optional.of(Pattern.compile(this.tableName.getNameAsString() + ".*")), false).get()).forEach(t -> {
            Void cfr_ignored_0 = (Void)this.admin.enableTable(t).join();
        });
        try {
            table1.get(get).get();
        }
        catch (Exception e) {
            ok = false;
        }
        try {
            table2.get(get).get();
        }
        catch (Exception e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(tableName1));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(tableName2));
    }

    @Test
    public void testEnableTableRetainAssignment() throws Exception {
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        this.createTableWithDefaultConf(this.tableName, Optional.of(splitKeys));
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        List regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        this.admin.disableTable(this.tableName).join();
        this.admin.enableTable(this.tableName).join();
        List regions2 = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Assert.assertEquals((long)regions.size(), (long)regions2.size());
        Assert.assertTrue((boolean)regions2.containsAll(regions));
    }

    @Test
    public void testDisableCatalogTable() throws Exception {
        try {
            this.admin.disableTable(TableName.META_TABLE_NAME).join();
            Assert.fail((String)"Expected to throw ConstraintException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createTableWithDefaultConf(this.tableName);
    }

    @Test
    public void testAddColumnFamily() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        this.admin.addColumnFamily(this.tableName, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
    }

    @Test
    public void testAddSameColumnFamilyTwice() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        this.admin.addColumnFamily(this.tableName, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
        try {
            this.admin.addColumnFamily(this.tableName, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).join();
            Assert.fail((String)"Delete a non-exist column family should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testModifyColumnFamily() throws Exception {
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0);
        int blockSize = cfd.getBlocksize();
        this.admin.createTable(tdBuilder.addColumnFamily(cfd).build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        int newBlockSize = 2 * blockSize;
        cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_0).setBlocksize(newBlockSize).build();
        this.admin.modifyColumnFamily(this.tableName, cfd).join();
        TableDescriptor htd = (TableDescriptor)this.admin.getTableDescriptor(this.tableName).get();
        ColumnFamilyDescriptor hcfd = htd.getColumnFamily(FAMILY_0);
        Assert.assertTrue((hcfd.getBlocksize() == newBlockSize ? 1 : 0) != 0);
    }

    @Test
    public void testModifyNonExistingColumnFamily() throws Exception {
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0);
        int blockSize = cfd.getBlocksize();
        this.admin.createTable(tdBuilder.addColumnFamily(cfd).build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        int newBlockSize = 2 * blockSize;
        cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_1).setBlocksize(newBlockSize).build();
        try {
            this.admin.modifyColumnFamily(this.tableName, cfd).join();
            Assert.fail((String)"Modify a non-exist column family should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteColumnFamily() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
        this.admin.deleteColumnFamily(this.tableName, FAMILY_1).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
    }

    @Test
    public void testDeleteSameColumnFamilyTwice() throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
        this.admin.createTable(builder.build()).join();
        this.admin.disableTable(this.tableName).join();
        this.verifyTableDescriptor(this.tableName, FAMILY_0, FAMILY_1);
        this.admin.deleteColumnFamily(this.tableName, FAMILY_1).join();
        this.verifyTableDescriptor(this.tableName, new byte[][]{FAMILY_0});
        try {
            this.admin.deleteColumnFamily(this.tableName, FAMILY_1).join();
            Assert.fail((String)"Delete a non-exist column family should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyTableDescriptor(TableName tableName, byte[] ... families) throws Exception {
        TableDescriptor htd = (TableDescriptor)this.admin.getTableDescriptor(tableName).get();
        this.verifyTableDescriptor(htd, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        this.verifyTableDescriptor(td, tableName, families);
    }

    private void verifyTableDescriptor(TableDescriptor htd, TableName tableName, byte[] ... families) {
        Set htdFamilies = htd.getColumnFamilyNames();
        Assert.assertEquals((Object)tableName, (Object)htd.getTableName());
        Assert.assertEquals((long)families.length, (long)htdFamilies.size());
        for (byte[] familyName : families) {
            Assert.assertTrue((String)("Expected family " + Bytes.toString((byte[])familyName)), (boolean)htdFamilies.contains(familyName));
        }
    }

    @Test
    public void testIsTableEnabledAndDisabled() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableEnabled(this.tableName).get()));
        Assert.assertFalse((boolean)((Boolean)this.admin.isTableDisabled(this.tableName).get()));
        this.admin.disableTable(this.tableName).join();
        Assert.assertFalse((boolean)((Boolean)this.admin.isTableEnabled(this.tableName).get()));
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableDisabled(this.tableName).get()));
    }

    @Test
    public void testTableAvailableWithRandomSplitKeys() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        byte[][] splitKeys = new byte[1][];
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}};
        boolean tableAvailable = (Boolean)this.admin.isTableAvailable(this.tableName, (byte[][])splitKeys).get();
        Assert.assertFalse((String)"Table should be created with 1 row in META", (boolean)tableAvailable);
    }

    @Test
    public void testCompactionTimestamps() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        RawAsyncTable table = ASYNC_CONN.getRawTable(this.tableName);
        Optional ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts.isPresent());
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v"));
        table.put(p).join();
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts.isPresent());
        this.admin.flush(this.tableName).join();
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts.isPresent());
        byte[] regionName = ((HRegionLocation)ASYNC_CONN.getRegionLocator(this.tableName).getRegionLocation(Bytes.toBytes((String)"row1")).get()).getRegionInfo().getRegionName();
        Optional ts1 = (Optional)this.admin.getLastMajorCompactionTimestampForRegion(regionName).get();
        Assert.assertFalse((boolean)ts1.isPresent());
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v"));
        table.put(p).join();
        this.admin.flush(this.tableName).join();
        ts1 = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertFalse((boolean)ts1.isPresent());
        for (int i = 0; i < 3; ++i) {
            table.put(p).join();
            this.admin.flush(this.tableName).join();
        }
        this.admin.majorCompact(this.tableName).join();
        long curt = System.currentTimeMillis();
        long waitTime = 10000L;
        long endt = curt + waitTime;
        CompactionState state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
        LOG.info((Object)("Current compaction state 1 is " + state));
        while (state == CompactionState.NONE && curt < endt) {
            Thread.sleep(100L);
            state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
            curt = System.currentTimeMillis();
            LOG.info((Object)("Current compaction state 2 is " + state));
        }
        if (state == CompactionState.MAJOR) {
            state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
            LOG.info((Object)("Current compaction state 3 is " + state));
            while (state != CompactionState.NONE && curt < endt) {
                Thread.sleep(10L);
                state = (CompactionState)this.admin.getCompactionState(this.tableName).get();
                LOG.info((Object)("Current compaction state 4 is " + state));
            }
        }
        Thread.sleep(TEST_UTIL.getConfiguration().getInt("hbase.regionserver.msginterval", 3000) * 2);
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).get();
        Assert.assertTrue((boolean)ts.isPresent());
        Assert.assertTrue(((Long)ts.get() > 0L ? 1 : 0) != 0);
        ts1 = (Optional)this.admin.getLastMajorCompactionTimestampForRegion(regionName).get();
        Assert.assertTrue((boolean)ts1.isPresent());
        Assert.assertEquals(ts.get(), ts1.get());
        table.put(p).join();
        this.admin.flush(this.tableName).join();
        ts = (Optional)this.admin.getLastMajorCompactionTimestamp(this.tableName).join();
        Assert.assertTrue((boolean)ts.isPresent());
        Assert.assertEquals(ts.get(), ts1.get());
        ts1 = (Optional)this.admin.getLastMajorCompactionTimestampForRegion(regionName).get();
        Assert.assertTrue((boolean)ts1.isPresent());
        Assert.assertEquals(ts.get(), ts1.get());
    }
}

