/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBase;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableBatch {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static int COUNT = 1000;
    private static AsyncConnection CONN;
    private static byte[][] SPLIT_KEYS;
    @Parameterized.Parameter(value=0)
    public String tableType;
    @Parameterized.Parameter(value=1)
    public Function<TableName, AsyncTableBase> tableGetter;

    private static RawAsyncTable getRawTable(TableName tableName) {
        return CONN.getRawTable(tableName);
    }

    private static AsyncTable getTable(TableName tableName) {
        return CONN.getTable(tableName, (ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters(name="{index}: type={0}")
    public static List<Object[]> params() {
        Function<TableName, AsyncTableBase> rawTableGetter = TestAsyncTableBatch::getRawTable;
        Function<TableName, AsyncTableBase> tableGetter = TestAsyncTableBatch::getTable;
        return Arrays.asList({"raw", rawTableGetter}, {"normal", tableGetter});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        SPLIT_KEYS = new byte[8][];
        for (int i = 111; i < 999; i += 111) {
            TestAsyncTableBatch.SPLIT_KEYS[i / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() throws IOException, InterruptedException {
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, SPLIT_KEYS);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    @After
    public void tearDownAfterTest() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.isTableEnabled(TABLE_NAME)) {
            admin.disableTable(TABLE_NAME);
        }
        admin.deleteTable(TABLE_NAME);
    }

    private byte[] getRow(int i) {
        return Bytes.toBytes((String)String.format("%03d", i));
    }

    @Test
    public void test() throws InterruptedException, ExecutionException, IOException {
        AsyncTableBase table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(this.getRow(i)).addColumn(FAMILY, CQ, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
        List results = (List)table.getAll(IntStream.range(0, COUNT).mapToObj(i -> Arrays.asList(new Get(this.getRow(i)), new Get(Arrays.copyOf(this.getRow(i), 4)))).flatMap(l -> l.stream()).collect(Collectors.toList())).get();
        Assert.assertEquals((long)(2 * COUNT), (long)results.size());
        for (int i2 = 0; i2 < COUNT; ++i2) {
            Assert.assertEquals((long)i2, (long)Bytes.toInt((byte[])((Result)results.get(2 * i2)).getValue(FAMILY, CQ)));
            Assert.assertTrue((boolean)((Result)results.get(2 * i2 + 1)).isEmpty());
        }
        Admin admin = TEST_UTIL.getAdmin();
        admin.flush(TABLE_NAME);
        TEST_UTIL.getHBaseCluster().getRegions(TABLE_NAME).forEach(r -> {
            byte[] startKey = r.getRegionInfo().getStartKey();
            int number = startKey.length == 0 ? 55 : Integer.parseInt(Bytes.toString((byte[])startKey));
            byte[] splitPoint = Bytes.toBytes((String)String.format("%03d", number + 55));
            try {
                admin.splitRegion(r.getRegionInfo().getRegionName(), splitPoint);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        Thread.sleep(5000L);
        table.deleteAll(IntStream.range(0, COUNT).mapToObj(i -> new Delete(this.getRow(i))).collect(Collectors.toList())).get();
        results = (List)table.getAll(IntStream.range(0, COUNT).mapToObj(i -> new Get(this.getRow(i))).collect(Collectors.toList())).get();
        Assert.assertEquals((long)COUNT, (long)results.size());
        results.forEach(r -> Assert.assertTrue((boolean)r.isEmpty()));
    }

    @Test
    public void testMixed() throws InterruptedException, ExecutionException {
        AsyncTableBase table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(IntStream.range(0, 5).mapToObj(i -> new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, CQ, Bytes.toBytes((long)i))).collect(Collectors.toList())).get();
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new Get(Bytes.toBytes((int)0)));
        actions.add(new Put(Bytes.toBytes((int)1)).addColumn(FAMILY, CQ, Bytes.toBytes((long)2L)));
        actions.add(new Delete(Bytes.toBytes((int)2)));
        actions.add(new Increment(Bytes.toBytes((int)3)).addColumn(FAMILY, CQ, 1L));
        actions.add(new Append(Bytes.toBytes((int)4)).addColumn(FAMILY, CQ, Bytes.toBytes((int)4)));
        List results = (List)table.batchAll(actions).get();
        Assert.assertEquals((long)5L, (long)results.size());
        Result getResult = (Result)results.get(0);
        Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])getResult.getValue(FAMILY, CQ)));
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])((Result)table.get(new Get(Bytes.toBytes((int)1))).get()).getValue(FAMILY, CQ)));
        Assert.assertTrue((boolean)((Result)table.get(new Get(Bytes.toBytes((int)2))).get()).isEmpty());
        Result incrementResult = (Result)results.get(3);
        Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])incrementResult.getValue(FAMILY, CQ)));
        Result appendResult = (Result)results.get(4);
        byte[] appendValue = appendResult.getValue(FAMILY, CQ);
        Assert.assertEquals((long)12L, (long)appendValue.length);
        Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])appendValue));
        Assert.assertEquals((long)4L, (long)Bytes.toInt((byte[])appendValue, (int)8));
    }

    @Test
    public void testPartialSuccess() throws IOException, InterruptedException, ExecutionException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor htd = new HTableDescriptor(admin.getTableDescriptor(TABLE_NAME));
        htd.addCoprocessor(ErrorInjectObserver.class.getName());
        admin.modifyTable(TABLE_NAME, (TableDescriptor)htd);
        AsyncTableBase table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(Arrays.asList(SPLIT_KEYS).stream().map(k -> new Put(k).addColumn(FAMILY, CQ, k)).collect(Collectors.toList())).get();
        List futures = table.get(Arrays.asList(SPLIT_KEYS).stream().map(k -> new Get(k)).collect(Collectors.toList()));
        for (int i = 0; i < SPLIT_KEYS.length - 1; ++i) {
            Assert.assertArrayEquals((byte[])SPLIT_KEYS[i], (byte[])((Result)((CompletableFuture)futures.get(i)).get()).getValue(FAMILY, CQ));
        }
        try {
            ((CompletableFuture)futures.get(SPLIT_KEYS.length - 1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
        }
    }

    public static final class ErrorInjectObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().getEndKey().length == 0) {
                throw new DoNotRetryRegionException("Inject Error");
            }
        }
    }
}

