/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBase;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanAll
extends AbstractTestAsyncTableScan {
    @Parameterized.Parameter(value=0)
    public String tableType;
    @Parameterized.Parameter(value=1)
    public Supplier<AsyncTableBase> getTable;
    @Parameterized.Parameter(value=2)
    public String scanType;
    @Parameterized.Parameter(value=3)
    public Supplier<Scan> scanCreator;

    private static RawAsyncTable getRawTable() {
        return ASYNC_CONN.getRawTable(TABLE_NAME);
    }

    private static AsyncTable getTable() {
        return ASYNC_CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters(name="{index}: table={0}, scan={2}")
    public static List<Object[]> params() {
        Supplier<AsyncTableBase> rawTable = TestAsyncTableScanAll::getRawTable;
        Supplier<AsyncTableBase> normalTable = TestAsyncTableScanAll::getTable;
        return TestAsyncTableScanAll.getScanCreater().stream().flatMap(p -> Arrays.asList({"raw", rawTable, p.getFirst(), p.getSecond()}, {"normal", normalTable, p.getFirst(), p.getSecond()}).stream()).collect(Collectors.toList());
    }

    @Override
    protected Scan createScan() {
        return this.scanCreator.get();
    }

    @Override
    protected List<Result> doScan(Scan scan) throws Exception {
        List<Result> results = (List<Result>)this.getTable.get().scanAll(scan).get();
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }
}

