/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.SimpleRawScanResultConsumer;
import org.apache.hadoop.hbase.client.SimpleScanResultConsumer;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanMetrics {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"ScanMetrics");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection CONN;
    private static int NUM_REGIONS;
    @Parameterized.Parameter(value=0)
    public String methodName;
    @Parameterized.Parameter(value=1)
    public ScanWithMetrics method;

    @Parameterized.Parameters(name="{index}: scan={0}")
    public static List<Object[]> params() {
        ScanWithMetrics doScanWithRawAsyncTable = TestAsyncTableScanMetrics::doScanWithRawAsyncTable;
        ScanWithMetrics doScanWithAsyncTableScan = TestAsyncTableScanMetrics::doScanWithAsyncTableScan;
        ScanWithMetrics doScanWithAsyncTableScanner = TestAsyncTableScanMetrics::doScanWithAsyncTableScanner;
        return Arrays.asList({"doScanWithRawAsyncTable", doScanWithRawAsyncTable}, {"doScanWithAsyncTableScan", doScanWithAsyncTableScan}, {"doScanWithAsyncTableScanner", doScanWithAsyncTableScanner});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        try (Table table = UTIL.createMultiRegionTable(TABLE_NAME, CF);){
            table.put(Arrays.asList(new Put(Bytes.toBytes((String)"zzz1")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"zzz2")).addColumn(CF, CQ, VALUE), new Put(Bytes.toBytes((String)"zzz3")).addColumn(CF, CQ, VALUE)));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        NUM_REGIONS = UTIL.getHBaseCluster().getRegions(TABLE_NAME).size();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)CONN);
        UTIL.shutdownMiniCluster();
    }

    private static Pair<List<Result>, ScanMetrics> doScanWithRawAsyncTable(Scan scan) throws IOException, InterruptedException {
        Result result;
        SimpleRawScanResultConsumer consumer = new SimpleRawScanResultConsumer();
        CONN.getRawTable(TABLE_NAME).scan(scan, (RawScanResultConsumer)consumer);
        ArrayList<Result> results = new ArrayList<Result>();
        while ((result = consumer.take()) != null) {
            results.add(result);
        }
        return Pair.newPair(results, (Object)consumer.getScanMetrics());
    }

    private static Pair<List<Result>, ScanMetrics> doScanWithAsyncTableScan(Scan scan) throws Exception {
        SimpleScanResultConsumer consumer = new SimpleScanResultConsumer();
        CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool()).scan(scan, (ScanResultConsumer)consumer);
        return Pair.newPair(consumer.getAll(), (Object)consumer.getScanMetrics());
    }

    private static Pair<List<Result>, ScanMetrics> doScanWithAsyncTableScanner(Scan scan) throws IOException {
        try (ResultScanner scanner = CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool()).getScanner(scan);){
            Result result;
            ArrayList<Result> results = new ArrayList<Result>();
            while ((result = scanner.next()) != null) {
                results.add(result);
            }
            Pair pair = Pair.newPair(results, (Object)scanner.getScanMetrics());
            return pair;
        }
    }

    @Test
    public void testNoScanMetrics() throws Exception {
        Pair<List<Result>, ScanMetrics> pair = this.method.scan(new Scan());
        Assert.assertEquals((long)3L, (long)((List)pair.getFirst()).size());
        Assert.assertNull((Object)pair.getSecond());
    }

    @Test
    public void testScanMetrics() throws Exception {
        Pair<List<Result>, ScanMetrics> pair = this.method.scan(new Scan().setScanMetricsEnabled(true));
        List results = (List)pair.getFirst();
        Assert.assertEquals((long)3L, (long)results.size());
        long bytes = results.stream().flatMap(r -> Arrays.asList(r.rawCells()).stream()).mapToLong(c -> PrivateCellUtil.estimatedSerializedSizeOf((Cell)c)).sum();
        ScanMetrics scanMetrics = (ScanMetrics)pair.getSecond();
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRegions.get());
        Assert.assertEquals((long)bytes, (long)scanMetrics.countOfBytesInResults.get());
        Assert.assertEquals((long)NUM_REGIONS, (long)scanMetrics.countOfRPCcalls.get());
        Assert.assertEquals((long)3L, (long)scanMetrics.countOfRowsScanned.get());
    }

    @FunctionalInterface
    private static interface ScanWithMetrics {
        public Pair<List<Result>, ScanMetrics> scan(Scan var1) throws Exception;
    }
}

