/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestFromClientSideNoCodec {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.client.default.rpc.codec", "");
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testBasics() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] fs = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"cf3")};
        Table ht = TEST_UTIL.createTable(tableName, (byte[][])fs);
        byte[] row = Bytes.toBytes((String)"row");
        Put p = new Put(row);
        for (byte[] f : fs) {
            p.addColumn(f, f, f);
        }
        ht.put(p);
        Result r = ht.get(new Get(row));
        int i = 0;
        CellScanner cellScanner = r.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] f = fs[i++];
            Assert.assertTrue((String)Bytes.toString((byte[])f), (boolean)Bytes.equals((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])f, (int)0, (int)f.length));
        }
        byte[] f = fs[0];
        Get get = new Get(row);
        get.addFamily(f);
        r = ht.get(get);
        Assert.assertTrue((String)r.toString(), (boolean)r.containsColumn(f, f));
        ResultScanner scanner = ht.getScanner(new Scan());
        int count = 0;
        while ((r = scanner.next()) != null) {
            Assert.assertTrue((r.listCells().size() == 3 ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNoCodec() {
        Configuration c = new Configuration();
        c.set("hbase.client.default.rpc.codec", "");
        String codec = AbstractRpcClient.getDefaultCodec((Configuration)c);
        Assert.assertTrue((codec == null || codec.length() == 0 ? 1 : 0) != 0);
    }
}

