/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestResultSizeEstimation {
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final int TAG_DATA_SIZE = 2048;
    static final int SCANNER_DATA_LIMIT = 2304;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.setLong("hbase.client.scanner.max.result.size", 2304L);
        conf.setBoolean("hbase.client.log.scanner.activity", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testResultSizeEstimation() throws Exception {
        byte[] ROW1 = Bytes.toBytes((String)"testRow1");
        byte[] ROW2 = Bytes.toBytes((String)"testRow2");
        byte[] FAMILY = Bytes.toBytes((String)"testFamily");
        byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
        byte[] VALUE = Bytes.toBytes((String)"testValue");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table table = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);
        Put p = new Put(ROW1);
        p.add((Cell)new KeyValue(ROW1, FAMILY, QUALIFIER, Long.MAX_VALUE, VALUE));
        table.put(p);
        p = new Put(ROW2);
        p.add((Cell)new KeyValue(ROW2, FAMILY, QUALIFIER, Long.MAX_VALUE, VALUE));
        table.put(p);
        Scan s = new Scan();
        s.setMaxResultSize(2304L);
        ResultScanner rs = table.getScanner(s);
        int count = 0;
        while (rs.next() != null) {
            ++count;
        }
        Assert.assertEquals((String)"Result size estimation did not work properly", (long)2L, (long)count);
        rs.close();
        table.close();
    }

    @Test
    public void testResultSizeEstimationWithTags() throws Exception {
        byte[] ROW1 = Bytes.toBytes((String)"testRow1");
        byte[] ROW2 = Bytes.toBytes((String)"testRow2");
        byte[] FAMILY = Bytes.toBytes((String)"testFamily");
        byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
        byte[] VALUE = Bytes.toBytes((String)"testValue");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = new byte[][]{FAMILY};
        Table table = TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);
        Put p = new Put(ROW1);
        p.add((Cell)new KeyValue(ROW1, FAMILY, QUALIFIER, Long.MAX_VALUE, VALUE, new Tag[]{new ArrayBackedTag(1, new byte[2048])}));
        table.put(p);
        p = new Put(ROW2);
        p.add((Cell)new KeyValue(ROW2, FAMILY, QUALIFIER, Long.MAX_VALUE, VALUE, new Tag[]{new ArrayBackedTag(1, new byte[2048])}));
        table.put(p);
        Scan s = new Scan();
        s.setMaxResultSize(2304L);
        ResultScanner rs = table.getScanner(s);
        int count = 0;
        while (rs.next() != null) {
            ++count;
        }
        Assert.assertEquals((String)"Result size estimation did not work properly", (long)2L, (long)count);
        rs.close();
        table.close();
    }
}

