/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ZKAsyncRegistry;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestZKAsyncRegistry {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZKAsyncRegistry REGISTRY;

    static void waitUntilAllReplicasHavingRegionLocation(final TableName tbl) throws IOException {
        TEST_UTIL.waitFor(TEST_UTIL.getConfiguration().getLong("hbase.client.sync.wait.timeout.msec", 60000L), 200L, true, new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                return TEST_UTIL.explainTableAvailability(tbl);
            }

            public boolean evaluate() throws IOException {
                AtomicBoolean ready = new AtomicBoolean(true);
                try {
                    RegionLocations locs = (RegionLocations)REGISTRY.getMetaRegionLocation().get();
                    Assert.assertEquals((long)3L, (long)locs.getRegionLocations().length);
                    IntStream.range(0, 3).forEach(i -> {
                        HRegionLocation loc = locs.getRegionLocation(i);
                        if (loc == null) {
                            ready.set(false);
                        }
                    });
                }
                catch (Exception e) {
                    ready.set(false);
                }
                return ready.get();
            }
        });
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        TEST_UTIL.startMiniCluster(3);
        REGISTRY = new ZKAsyncRegistry(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)REGISTRY);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, ExecutionException, IOException {
        Assert.assertEquals((Object)TEST_UTIL.getHBaseCluster().getClusterStatus().getClusterId(), REGISTRY.getClusterId().get());
        Assert.assertEquals((long)TEST_UTIL.getHBaseCluster().getClusterStatus().getServersSize(), (long)((Integer)REGISTRY.getCurrentNrHRS().get()).intValue());
        Assert.assertEquals((Object)TEST_UTIL.getHBaseCluster().getMaster().getServerName(), REGISTRY.getMasterAddress().get());
        Assert.assertEquals((long)-1L, (long)((Integer)REGISTRY.getMasterInfoPort().get()).intValue());
        TestZKAsyncRegistry.waitUntilAllReplicasHavingRegionLocation(TableName.META_TABLE_NAME);
        RegionLocations locs = (RegionLocations)REGISTRY.getMetaRegionLocation().get();
        Assert.assertEquals((long)3L, (long)locs.getRegionLocations().length);
        IntStream.range(0, 3).forEach(i -> {
            HRegionLocation loc = locs.getRegionLocation(i);
            Assert.assertNotNull((String)("Replica " + i + " doesn't have location"), (Object)loc);
            Assert.assertTrue((boolean)loc.getRegionInfo().getTable().equals((Object)TableName.META_TABLE_NAME));
            Assert.assertEquals((long)i, (long)loc.getRegionInfo().getReplicaId());
        });
    }
}

