/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterAllFilter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestRegionObserverInterface {
    private static final Log LOG = LogFactory.getLog(TestRegionObserverInterface.class);
    public static final TableName TEST_TABLE = TableName.valueOf((String)"TestTable");
    public static final byte[] A = Bytes.toBytes((String)"a");
    public static final byte[] B = Bytes.toBytes((String)"b");
    public static final byte[] C = Bytes.toBytes((String)"c");
    public static final byte[] ROW = Bytes.toBytes((String)"testrow");
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster = null;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", true);
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{SimpleRegionObserver.class.getName()});
        util.startMiniCluster();
        cluster = util.getMiniHBaseCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRegionObserver() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDelete", "hadPostStartRegionOperation", "hadPostCloseRegionOperation", "hadPostBatchMutateIndispensably"}, tableName, new Boolean[]{false, false, false, false, false, false, false, false});
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            table.put(put);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadPreBatchMutate", "hadPostBatchMutate", "hadDelete", "hadPostStartRegionOperation", "hadPostCloseRegionOperation", "hadPostBatchMutateIndispensably"}, TEST_TABLE, new Boolean[]{false, false, true, true, true, true, false, true, true, true});
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreOpen", "getCtPostOpen", "getCtPreClose", "getCtPostClose"}, tableName, new Integer[]{1, 1, 0, 0});
            Get get = new Get(ROW);
            get.addColumn(A, A);
            get.addColumn(B, B);
            get.addColumn(C, C);
            table.get(get);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDelete", "hadPrePreparedDeleteTS"}, tableName, new Boolean[]{true, true, true, true, false, false});
            Delete delete = new Delete(ROW);
            delete.addColumn(A, A);
            delete.addColumn(B, B);
            delete.addColumn(C, C);
            table.delete(delete);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadPreBatchMutate", "hadPostBatchMutate", "hadDelete", "hadPrePreparedDeleteTS"}, tableName, new Boolean[]{true, true, true, true, true, true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreOpen", "getCtPostOpen", "getCtPreClose", "getCtPostClose"}, tableName, new Integer[]{1, 1, 1, 1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRowMutation() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDeleted"}, tableName, new Boolean[]{false, false, false, false, false});
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            Delete delete = new Delete(ROW);
            delete.addColumn(A, A);
            delete.addColumn(B, B);
            delete.addColumn(C, C);
            RowMutations arm = new RowMutations(ROW);
            arm.add(put);
            arm.add(delete);
            table.mutateRow(arm);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDeleted"}, tableName, new Boolean[]{false, false, true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testIncrementHook() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            Increment inc = new Increment(Bytes.toBytes((int)0));
            inc.addColumn(A, A, 1L);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreIncrement", "hadPostIncrement", "hadPreIncrementAfterRowLock"}, tableName, new Boolean[]{false, false, false});
            table.increment(inc);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreIncrement", "hadPostIncrement", "hadPreIncrementAfterRowLock"}, tableName, new Boolean[]{true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCheckAndPutHooks() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        try (Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});){
            Put p = new Put(Bytes.toBytes((int)0));
            p.addColumn(A, A, A);
            table.put(p);
            p = new Put(Bytes.toBytes((int)0));
            p.addColumn(A, A, A);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreCheckAndPut", "hadPreCheckAndPutAfterRowLock", "hadPostCheckAndPut"}, tableName, new Boolean[]{false, false, false});
            table.checkAndPut(Bytes.toBytes((int)0), A, A, A, p);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreCheckAndPut", "hadPreCheckAndPutAfterRowLock", "hadPostCheckAndPut"}, tableName, new Boolean[]{true, true, true});
        }
        finally {
            util.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCheckAndDeleteHooks() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            Put p = new Put(Bytes.toBytes((int)0));
            p.addColumn(A, A, A);
            table.put(p);
            Delete d = new Delete(Bytes.toBytes((int)0));
            table.delete(d);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreCheckAndDelete", "hadPreCheckAndDeleteAfterRowLock", "hadPostCheckAndDelete"}, tableName, new Boolean[]{false, false, false});
            table.checkAndDelete(Bytes.toBytes((int)0), A, A, A, d);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreCheckAndDelete", "hadPreCheckAndDeleteAfterRowLock", "hadPostCheckAndDelete"}, tableName, new Boolean[]{true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testAppendHook() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            Append app = new Append(Bytes.toBytes((int)0));
            app.addColumn(A, A, A);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreAppend", "hadPostAppend", "hadPreAppendAfterRowLock"}, tableName, new Boolean[]{false, false, false});
            table.append(app);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreAppend", "hadPostAppend", "hadPreAppendAfterRowLock"}, tableName, new Boolean[]{true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHBase3583() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        util.waitUntilAllRegionsAssigned(tableName);
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "wasScannerNextCalled", "wasScannerCloseCalled"}, tableName, new Boolean[]{false, false, false, false});
        Table table = util.getConnection().getTable(tableName);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        Get get = new Get(ROW);
        get.addColumn(A, A);
        table.get(get);
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "wasScannerNextCalled", "wasScannerCloseCalled"}, tableName, new Boolean[]{true, true, false, false});
        Scan s = new Scan();
        try (ResultScanner scanner = table.getScanner(s);){
            Result rr = scanner.next();
            while (rr != null) {
                rr = scanner.next();
            }
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"wasScannerNextCalled", "wasScannerCloseCalled"}, tableName, new Boolean[]{true, true});
        util.deleteTable(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHBASE14489() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A});
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        Scan s = new Scan();
        s.setFilter((Filter)new FilterAllFilter());
        try (ResultScanner scanner = table.getScanner(s);){
            Result rr = scanner.next();
            while (rr != null) {
                rr = scanner.next();
            }
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"wasScannerFilterRowCalled"}, tableName, new Boolean[]{true});
        util.deleteTable(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHBase3758() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadDeleted", "wasScannerOpenCalled"}, tableName, new Boolean[]{false, false});
        Table table = util.getConnection().getTable(tableName);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        Delete delete = new Delete(ROW);
        table.delete(delete);
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadDeleted", "wasScannerOpenCalled"}, tableName, new Boolean[]{true, false});
        Scan s = new Scan();
        try (ResultScanner scanner = table.getScanner(s);){
            Result rr = scanner.next();
            while (rr != null) {
                rr = scanner.next();
            }
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"wasScannerOpenCalled"}, tableName, new Boolean[]{true});
        util.deleteTable(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCompactionOverride() throws Exception {
        int i;
        TableName compactTable = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = util.getAdmin();
        if (admin.tableExists(compactTable)) {
            admin.disableTable(compactTable);
            admin.deleteTable(compactTable);
        }
        HTableDescriptor htd = new HTableDescriptor(compactTable);
        htd.addFamily(new HColumnDescriptor(A));
        htd.addCoprocessor(EvenOnlyCompactor.class.getName());
        admin.createTable((TableDescriptor)htd);
        Table table = util.getConnection().getTable(compactTable);
        for (long i2 = 1L; i2 <= 10L; ++i2) {
            byte[] iBytes = Bytes.toBytes((long)i2);
            Put put = new Put(iBytes);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(A, A, iBytes);
            table.put(put);
        }
        HRegion firstRegion = cluster.getRegions(compactTable).get(0);
        Coprocessor cp = firstRegion.getCoprocessorHost().findCoprocessor(EvenOnlyCompactor.class);
        Assert.assertNotNull((String)"EvenOnlyCompactor coprocessor should be loaded", (Object)cp);
        EvenOnlyCompactor compactor = (EvenOnlyCompactor)cp;
        long ts = System.currentTimeMillis();
        admin.flush(compactTable);
        for (i = 0; i < 10 && compactor.lastFlush < ts; ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Flush didn't complete", (compactor.lastFlush >= ts ? 1 : 0) != 0);
        LOG.debug((Object)"Flush complete");
        ts = compactor.lastFlush;
        admin.majorCompact(compactTable);
        for (i = 0; i < 30 && compactor.lastCompaction < ts; ++i) {
            Thread.sleep(1000L);
        }
        LOG.debug((Object)("Last compaction was at " + compactor.lastCompaction));
        Assert.assertTrue((String)"Compaction didn't complete", (compactor.lastCompaction >= ts ? 1 : 0) != 0);
        try (ResultScanner scanner = table.getScanner(new Scan());){
            for (long i3 = 2L; i3 <= 10L; i3 += 2L) {
                Result r = scanner.next();
                Assert.assertNotNull((Object)r);
                Assert.assertFalse((boolean)r.isEmpty());
                byte[] iBytes = Bytes.toBytes((long)i3);
                Assert.assertArrayEquals((String)("Row should be " + i3), (byte[])r.getRow(), (byte[])iBytes);
                Assert.assertArrayEquals((String)("Value should be " + i3), (byte[])r.getValue(A, A), (byte[])iBytes);
            }
        }
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void bulkLoadHFileTest() throws Exception {
        String testName = TestRegionObserverInterface.class.getName() + "." + this.name.getMethodName();
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Configuration conf = util.getConfiguration();
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try (RegionLocator locator = util.getConnection().getRegionLocator(tableName);){
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreBulkLoadHFile", "hadPostBulkLoadHFile"}, tableName, new Boolean[]{false, false});
            FileSystem fs = util.getTestFileSystem();
            Path dir = util.getDataTestDirOnTestFS(testName).makeQualified(fs);
            Path familyDir = new Path(dir, Bytes.toString((byte[])A));
            TestRegionObserverInterface.createHFile(util.getConfiguration(), fs, new Path(familyDir, Bytes.toString((byte[])A)), A, A);
            new LoadIncrementalHFiles(conf).doBulkLoad(dir, util.getAdmin(), table, locator);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreBulkLoadHFile", "hadPostBulkLoadHFile"}, tableName, new Boolean[]{true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRecovery() throws Exception {
        LOG.info((Object)(TestRegionObserverInterface.class.getName() + "." + this.name.getMethodName()));
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try (RegionLocator locator = util.getConnection().getRegionLocator(tableName);){
            JVMClusterUtil.RegionServerThread rs1 = cluster.startRegionServer();
            ServerName sn2 = rs1.getRegionServer().getServerName();
            String regEN = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            util.getAdmin().move(regEN.getBytes(), sn2.getServerName().getBytes());
            while (!sn2.equals((Object)((HRegionLocation)locator.getAllRegionLocations().get(0)).getServerName())) {
                Thread.sleep(100L);
            }
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            table.put(put);
            table.put(put);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadPreBatchMutate", "hadPostBatchMutate", "hadDelete"}, tableName, new Boolean[]{false, false, true, true, true, true, false});
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreReplayWALs", "getCtPostReplayWALs", "getCtPreWALRestore", "getCtPostWALRestore", "getCtPrePut", "getCtPostPut"}, tableName, new Integer[]{0, 0, 0, 0, 2, 2});
            cluster.killRegionServer(rs1.getRegionServer().getServerName());
            Threads.sleep((long)1000L);
            util.waitUntilAllRegionsAssigned(tableName);
            LOG.info((Object)"All regions assigned");
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreReplayWALs", "getCtPostReplayWALs", "getCtPreWALRestore", "getCtPostWALRestore", "getCtPrePut", "getCtPostPut"}, tableName, new Integer[]{1, 1, 2, 2, 0, 0});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    @Test(timeout=300000L)
    public void testPreWALRestoreSkip() throws Exception {
        LOG.info((Object)(TestRegionObserverInterface.class.getName() + "." + this.name.getMethodName()));
        TableName tableName = TableName.valueOf((String)"SKIPPED_BY_PREWALRESTORE");
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try (RegionLocator locator = util.getConnection().getRegionLocator(tableName);){
            JVMClusterUtil.RegionServerThread rs1 = cluster.startRegionServer();
            ServerName sn2 = rs1.getRegionServer().getServerName();
            String regEN = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            util.getAdmin().move(regEN.getBytes(), sn2.getServerName().getBytes());
            while (!sn2.equals((Object)((HRegionLocation)locator.getAllRegionLocations().get(0)).getServerName())) {
                Thread.sleep(100L);
            }
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            table.put(put);
            cluster.killRegionServer(rs1.getRegionServer().getServerName());
            Threads.sleep((long)20000L);
            util.waitUntilAllRegionsAssigned(tableName);
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreWALRestore", "getCtPostWALRestore"}, tableName, new Integer[]{0, 0});
        util.deleteTable(tableName);
        table.close();
    }

    private void verifyMethodResult(Class<?> coprocessor, String[] methodName, TableName tableName, Object[] value) throws IOException {
        try {
            for (JVMClusterUtil.RegionServerThread t : cluster.getRegionServerThreads()) {
                if (!t.isAlive() || t.getRegionServer().isAborted() || t.getRegionServer().isStopping()) continue;
                for (RegionInfo r : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)t.getRegionServer().getRSRpcServices())) {
                    if (!r.getTable().equals((Object)tableName)) continue;
                    RegionCoprocessorHost cph = t.getRegionServer().getOnlineRegion(r.getRegionName()).getCoprocessorHost();
                    Coprocessor cp = cph.findCoprocessor(coprocessor.getName());
                    Assert.assertNotNull((Object)cp);
                    for (int i = 0; i < methodName.length; ++i) {
                        Method m = coprocessor.getMethod(methodName[i], new Class[0]);
                        Object o = m.invoke((Object)cp, new Object[0]);
                        Assert.assertTrue((String)("Result of " + coprocessor.getName() + "." + methodName[i] + " is expected to be " + value[i].toString() + ", while we get " + o.toString()), (boolean)o.equals(value[i]));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createHFile(Configuration conf, FileSystem fs, Path path, byte[] family, byte[] qualifier) throws IOException {
        HFileContext context = new HFileContextBuilder().build();
        long now = System.currentTimeMillis();
        try (HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)new CacheConfig(conf)).withPath(fs, path).withFileContext(context).create();){
            for (int i = 1; i <= 9; ++i) {
                KeyValue kv = new KeyValue(Bytes.toBytes((String)(i + "")), family, qualifier, now, Bytes.toBytes((String)(i + "")));
                writer.append((Cell)kv);
            }
        }
    }

    public static class EvenOnlyCompactor
    implements RegionCoprocessor,
    RegionObserver {
        long lastCompaction;
        long lastFlush;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, final InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            return new InternalScanner(){

                public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
                    boolean hasMore;
                    ArrayList internalResults = new ArrayList();
                    do {
                        hasMore = scanner.next(internalResults, scannerContext);
                        if (internalResults.isEmpty()) continue;
                        long row = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)internalResults.get(0))));
                        if (row % 2L == 0L) break;
                        internalResults.clear();
                    } while (hasMore);
                    if (!internalResults.isEmpty()) {
                        results.addAll(internalResults);
                    }
                    return hasMore;
                }

                public void close() throws IOException {
                    scanner.close();
                }
            };
        }

        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            this.lastCompaction = EnvironmentEdgeManager.currentTime();
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) {
            this.lastFlush = EnvironmentEdgeManager.currentTime();
        }
    }
}

