/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALCoprocessor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestWALObserver {
    private static final Log LOG = LogFactory.getLog(TestWALObserver.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] TEST_TABLE = Bytes.toBytes((String)"observedTable");
    private static byte[][] TEST_FAMILY = new byte[][]{Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam2"), Bytes.toBytes((String)"fam3")};
    private static byte[][] TEST_QUALIFIER = new byte[][]{Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"q3")};
    private static byte[][] TEST_VALUE = new byte[][]{Bytes.toBytes((String)"v1"), Bytes.toBytes((String)"v2"), Bytes.toBytes((String)"v3")};
    private static byte[] TEST_ROW = Bytes.toBytes((String)"testRow");
    @Rule
    public TestName currentTest = new TestName();
    private Configuration conf;
    private FileSystem fs;
    private Path hbaseRootDir;
    private Path hbaseWALRootDir;
    private Path oldLogDir;
    private Path logDir;
    private WALFactory wals;
    private static final byte[] UNSPECIFIED_REGION = new byte[0];

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.wal.classes", new String[]{SampleRegionWALCoprocessor.class.getName()});
        conf.set("hbase.coprocessor.region.classes", SampleRegionWALCoprocessor.class.getName());
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(1);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        Path hbaseWALRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbaseLogRoot"));
        LOG.info((Object)("hbase.rootdir=" + hbaseRootDir));
        FSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
        FSUtils.setWALRootDir((Configuration)conf, (Path)hbaseWALRootDir);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        this.hbaseWALRootDir = FSUtils.getWALRootDir((Configuration)this.conf);
        this.oldLogDir = new Path(this.hbaseWALRootDir, "oldWALs");
        String serverName = ServerName.valueOf((String)this.currentTest.getMethodName(), (int)16010, (long)System.currentTimeMillis()).toString();
        this.logDir = new Path(this.hbaseWALRootDir, AbstractFSWALProvider.getWALDirectoryName((String)serverName));
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseWALRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseWALRootDir, true);
        }
        this.wals = new WALFactory(this.conf, null, serverName);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.wals.shutdown();
        }
        catch (IOException exception) {
            LOG.warn((Object)("Ignoring failure to close wal factory. " + exception.getMessage()));
            LOG.debug((Object)"details of failure to close wal factory.", (Throwable)exception);
        }
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseWALRootDir, true);
    }

    @Test
    public void testWALObserverWriteToWAL() throws Exception {
        WAL log = this.wals.getWAL(UNSPECIFIED_REGION, null);
        this.verifyWritesSeen(log, this.getCoprocessor(log, SampleRegionWALCoprocessor.class), false);
    }

    private void verifyWritesSeen(WAL log, SampleRegionWALCoprocessor cp, boolean seesLegacy) throws Exception {
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        Path basedir = new Path(this.hbaseRootDir, Bytes.toString((byte[])TEST_TABLE));
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        cp.setTestValues(TEST_TABLE, TEST_ROW, TEST_FAMILY[0], TEST_QUALIFIER[0], TEST_FAMILY[1], TEST_QUALIFIER[1], TEST_FAMILY[2], TEST_QUALIFIER[2]);
        Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
        Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
        Put p = this.creatPutWith2Families(TEST_ROW);
        NavigableMap familyMap = p.getFamilyCellMap();
        WALEdit edit = new WALEdit();
        this.addFamilyMapToWALEdit(familyMap, edit);
        boolean foundFamily0 = false;
        boolean foundFamily2 = false;
        boolean modifiedFamily1 = false;
        ArrayList cells = edit.getCells();
        for (Cell cell : cells) {
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[1]) || Arrays.equals(CellUtil.cloneValue((Cell)cell), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertTrue((boolean)foundFamily0);
        Assert.assertFalse((boolean)foundFamily2);
        Assert.assertFalse((boolean)modifiedFamily1);
        long now = EnvironmentEdgeManager.currentTime();
        long txid = log.append((RegionInfo)hri, new WALKey(hri.getEncodedNameAsBytes(), hri.getTable(), now, new MultiVersionConcurrencyControl(), scopes), edit, true);
        log.sync(txid);
        foundFamily0 = false;
        foundFamily2 = false;
        modifiedFamily1 = false;
        for (Cell cell : cells) {
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(CellUtil.cloneFamily((Cell)cell), TEST_FAMILY[1]) || Arrays.equals(CellUtil.cloneValue((Cell)cell), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertFalse((boolean)foundFamily0);
        Assert.assertTrue((boolean)foundFamily2);
        Assert.assertTrue((boolean)modifiedFamily1);
        Assert.assertTrue((boolean)cp.isPreWALWriteCalled());
        Assert.assertTrue((boolean)cp.isPostWALWriteCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyWALEditAreNotSeen() throws Exception {
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        try (WAL log = this.wals.getWAL(UNSPECIFIED_REGION, null);){
            SampleRegionWALCoprocessor cp = this.getCoprocessor(log, SampleRegionWALCoprocessor.class);
            cp.setTestValues(TEST_TABLE, null, null, null, null, null, null, null);
            Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
            Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
            long now = EnvironmentEdgeManager.currentTime();
            long txid = log.append((RegionInfo)hri, new WALKey(hri.getEncodedNameAsBytes(), hri.getTable(), now, mvcc, scopes), new WALEdit(), true);
            log.sync(txid);
            Assert.assertFalse((String)"Empty WALEdit should skip coprocessor evaluation.", (boolean)cp.isPreWALWriteCalled());
            Assert.assertFalse((String)"Empty WALEdit should skip coprocessor evaluation.", (boolean)cp.isPostWALWriteCalled());
        }
    }

    @Test
    public void testWALCoprocessorReplay() throws Exception {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        final HTableDescriptor htd = this.getBasic3FamilyHTableDescriptor(tableName);
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        final HRegionInfo hri = new HRegionInfo(tableName, null, null);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        WAL wal = this.wals.getWAL(UNSPECIFIED_REGION, null);
        WALEdit edit = new WALEdit();
        long now = EnvironmentEdgeManager.currentTime();
        int countPerFamily = 1000;
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            scopes.put(hcd.getName(), 0);
        }
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, TEST_ROW, hcd.getName(), 1000, EnvironmentEdgeManager.getDelegate(), wal, scopes, mvcc);
        }
        wal.append((RegionInfo)hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, now, mvcc, scopes), edit, true);
        wal.sync();
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Path p = TestWALObserver.this.runWALSplit(newConf);
                LOG.info((Object)("WALSplit path == " + p));
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                WALFactory wals2 = new WALFactory(TestWALObserver.this.conf, null, ServerName.valueOf((String)(TestWALObserver.this.currentTest.getMethodName() + "2"), (int)16010, (long)System.currentTimeMillis()).toString());
                WAL wal2 = wals2.getWAL(UNSPECIFIED_REGION, null);
                HRegion region = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALObserver.this.hbaseRootDir, (RegionInfo)hri, (TableDescriptor)htd, (WAL)wal2, (RegionServerServices)TEST_UTIL.getHBaseCluster().getRegionServer(0), null);
                long seqid2 = region.getOpenSeqNum();
                SampleRegionWALCoprocessor cp2 = (SampleRegionWALCoprocessor)region.getCoprocessorHost().findCoprocessor(SampleRegionWALCoprocessor.class);
                Assert.assertNotNull((Object)cp2);
                Assert.assertTrue((boolean)cp2.isPreWALRestoreCalled());
                Assert.assertTrue((boolean)cp2.isPostWALRestoreCalled());
                region.close();
                wals2.close();
                return null;
            }
        });
    }

    @Test
    public void testWALObserverLoaded() throws Exception {
        WAL log = this.wals.getWAL(UNSPECIFIED_REGION, null);
        Assert.assertNotNull((Object)this.getCoprocessor(log, SampleRegionWALCoprocessor.class));
    }

    @Test
    public void testWALObserverRoll() throws Exception {
        WAL wal = this.wals.getWAL(UNSPECIFIED_REGION, null);
        SampleRegionWALCoprocessor cp = this.getCoprocessor(wal, SampleRegionWALCoprocessor.class);
        cp.setTestValues(TEST_TABLE, null, null, null, null, null, null, null);
        Assert.assertFalse((boolean)cp.isPreWALRollCalled());
        Assert.assertFalse((boolean)cp.isPostWALRollCalled());
        wal.rollWriter(true);
        Assert.assertTrue((boolean)cp.isPreWALRollCalled());
        Assert.assertTrue((boolean)cp.isPostWALRollCalled());
    }

    private SampleRegionWALCoprocessor getCoprocessor(WAL wal, Class<? extends SampleRegionWALCoprocessor> clazz) throws Exception {
        WALCoprocessorHost host = wal.getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(clazz.getName());
        return (SampleRegionWALCoprocessor)c;
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return new HRegionInfo(htd.getTableName(), null, null, false);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    private Put creatPutWith2Families(byte[] row) throws IOException {
        Put p = new Put(row);
        for (int i = 0; i < TEST_FAMILY.length - 1; ++i) {
            p.addColumn(TEST_FAMILY[i], TEST_QUALIFIER[i], TEST_VALUE[i]);
        }
        return p;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                walEdit.add(cell);
            }
        }
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = WALSplitter.split((Path)this.hbaseRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)c), (Configuration)c, (WALFactory)this.wals);
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info((Object)("Split file=" + splits.get(0)));
        return (Path)splits.get(0);
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, WAL wal, NavigableMap<byte[], Integer> scopes, MultiVersionConcurrencyControl mvcc) throws IOException {
        String familyStr = Bytes.toString((byte[])family);
        long txid = -1L;
        for (int j = 0; j < count; ++j) {
            byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(j));
            byte[] columnBytes = Bytes.toBytes((String)(familyStr + ":" + Integer.toString(j)));
            WALEdit edit = new WALEdit();
            edit.add((Cell)new KeyValue(rowName, family, qualifierBytes, ee.currentTime(), columnBytes));
            txid = wal.append((RegionInfo)hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, ee.currentTime(), mvcc), edit, true);
        }
        if (-1L != txid) {
            wal.sync(txid);
        }
    }

    private HTableDescriptor getBasic3FamilyHTableDescriptor(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return htd;
    }

    private HTableDescriptor createBasic3FamilyHTD(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes((String)"b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes((String)"c"));
        htd.addFamily(c);
        return htd;
    }
}

