/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MasterTests.class, SmallTests.class})
public class TestTimeoutExceptionInjector {
    private static final Log LOG = LogFactory.getLog(TestTimeoutExceptionInjector.class);

    @Test(timeout=60000L)
    public void testTimerTrigger() {
        long time = 10000000L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 10000000L);
        timer.start();
        timer.trigger();
        ((ForeignExceptionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).receive((ForeignException)((Object)Mockito.any(ForeignException.class)));
    }

    @Test
    public void testTimerPassesOnErrorInfo() {
        long time = 1000000L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 1000000L);
        timer.start();
        timer.trigger();
        ((ForeignExceptionListener)Mockito.verify((Object)listener)).receive((ForeignException)((Object)Mockito.any(ForeignException.class)));
    }

    @Test(timeout=60000L)
    public void testStartAfterComplete() throws InterruptedException {
        long time = 10L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 10L);
        timer.complete();
        try {
            timer.start();
            Assert.fail((String)"Timer should fail to start after complete.");
        }
        catch (IllegalStateException e) {
            LOG.debug((Object)("Correctly failed timer: " + e.getMessage()));
        }
        Thread.sleep(11L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{listener});
    }

    @Test(timeout=60000L)
    public void testStartAfterTrigger() throws InterruptedException {
        long time = 10L;
        ForeignExceptionListener listener = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(listener, 10L);
        timer.trigger();
        try {
            timer.start();
            Assert.fail((String)"Timer should fail to start after complete.");
        }
        catch (IllegalStateException e) {
            LOG.debug((Object)("Correctly failed timer: " + e.getMessage()));
        }
        Thread.sleep(20L);
        ((ForeignExceptionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).receive((ForeignException)((Object)Mockito.any(ForeignException.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }
}

