/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutputHelper;
import org.apache.hadoop.hbase.shaded.io.netty.channel.Channel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLocalAsyncOutput {
    private static EventLoopGroup GROUP = new NioEventLoopGroup();
    private static Class<? extends Channel> CHANNEL_CLASS = NioSocketChannel.class;
    private static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
        GROUP.shutdownGracefully();
    }

    @Test
    public void test() throws IOException, InterruptedException, ExecutionException {
        Path f = new Path(TEST_UTIL.getDataTestDir(), "test");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)TEST_UTIL.getConfiguration());
        AsyncFSOutput out = AsyncFSOutputHelper.createOutput((FileSystem)fs, (Path)f, (boolean)false, (boolean)true, (short)fs.getDefaultReplication(f), (long)fs.getDefaultBlockSize(f), (EventLoop)GROUP.next(), CHANNEL_CLASS);
        byte[] b = new byte[10];
        ThreadLocalRandom.current().nextBytes(b);
        out.write(b);
        Assert.assertEquals((long)b.length, (long)((Long)out.flush(true).get()));
        out.close();
        Assert.assertEquals((long)b.length, (long)fs.getFileStatus(f).getLen());
        byte[] actual = new byte[b.length];
        try (FSDataInputStream in = fs.open(f);){
            in.readFully(actual);
        }
        Assert.assertArrayEquals((byte[])b, (byte[])actual);
    }
}

