/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeCodec;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, SmallTests.class})
public class TestPrefixTreeEncoding {
    private static final Log LOG = LogFactory.getLog(TestPrefixTreeEncoding.class);
    private static final String CF = "EncodingTestCF";
    private static final byte[] CF_BYTES = Bytes.toBytes((String)"EncodingTestCF");
    private static final int NUM_ROWS_PER_BATCH = 50;
    private static final int NUM_COLS_PER_ROW = 20;
    private int numBatchesWritten = 0;
    private ConcurrentSkipListSet<Cell> kvset = new ConcurrentSkipListSet(CellComparatorImpl.COMPARATOR);
    private static boolean formatRowNum = false;
    private final boolean includesTag;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[]{false});
        paramList.add(new Object[]{true});
        return paramList;
    }

    public TestPrefixTreeEncoding(boolean includesTag) {
        this.includesTag = includesTag;
    }

    @Before
    public void setUp() throws Exception {
        this.kvset.clear();
        formatRowNum = false;
    }

    @Test
    public void testSeekBeforeWithFixedData() throws Exception {
        formatRowNum = true;
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        TestPrefixTreeEncoding.generateFixedTestData(this.kvset, batchId, false, this.includesTag, encoder, (HFileBlockEncodingContext)blkEncodingCtx, userDataStream);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker((CellComparator)CellComparatorImpl.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = baosInMemory.toByteArray();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        seeker.setCurrentBuffer((ByteBuff)new SingleByteBuff(readBuffer));
        Cell seekKey = PrivateCellUtil.createFirstDeleteFamilyCellOnRow((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 0), (byte[])CF_BYTES);
        seeker.seekToKeyInBlock(seekKey, true);
        Assert.assertEquals(null, (Object)seeker.getCell());
        seekKey = PrivateCellUtil.createFirstDeleteFamilyCellOnRow((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 16), (byte[])CF_BYTES);
        seeker.seekToKeyInBlock(seekKey, true);
        Assert.assertNotNull((Object)seeker.getCell());
        Assert.assertArrayEquals((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 15), (byte[])CellUtil.cloneRow((Cell)seeker.getCell()));
        seekKey = PrivateCellUtil.createFirstDeleteFamilyCellOnRow((byte[])Bytes.toBytes((String)"zzzz"), (byte[])CF_BYTES);
        seeker.seekToKeyInBlock(seekKey, true);
        Assert.assertNotNull((Object)seeker.getCell());
        Assert.assertArrayEquals((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 49), (byte[])CellUtil.cloneRow((Cell)seeker.getCell()));
    }

    @Test
    public void testScanWithRandomData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        TestPrefixTreeEncoding.generateRandomTestData(this.kvset, this.numBatchesWritten++, this.includesTag, encoder, (HFileBlockEncodingContext)blkEncodingCtx, userDataStream);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker((CellComparator)CellComparatorImpl.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = baosInMemory.toByteArray();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        seeker.setCurrentBuffer((ByteBuff)new SingleByteBuff(readBuffer));
        Cell previousKV = null;
        do {
            Cell currentKV = seeker.getCell();
            System.out.println(currentKV);
            if (previousKV != null && CellComparatorImpl.COMPARATOR.compare(currentKV, previousKV) < 0) {
                this.dumpInputKVSet();
                Assert.fail((String)("Current kv " + currentKV + " is smaller than previous keyvalue " + previousKV));
            }
            if (!this.includesTag) {
                Assert.assertFalse((currentKV.getTagsLength() > 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((currentKV.getTagsLength() > 0 ? 1 : 0) != 0);
            }
            previousKV = currentKV;
        } while (seeker.next());
    }

    @Test
    public void testSeekWithRandomData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        int batchId = this.numBatchesWritten++;
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        TestPrefixTreeEncoding.generateRandomTestData(this.kvset, batchId, this.includesTag, encoder, (HFileBlockEncodingContext)blkEncodingCtx, userDataStream);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker((CellComparator)CellComparatorImpl.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = baosInMemory.toByteArray();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        this.verifySeeking(seeker, readBuffer, batchId);
    }

    @Test
    public void testSeekWithFixedData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(this.includesTag).withCompression(Compression.Algorithm.NONE).build();
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(DataBlockEncoding.PREFIX_TREE, new byte[0], meta);
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        TestPrefixTreeEncoding.generateFixedTestData(this.kvset, batchId, this.includesTag, encoder, (HFileBlockEncodingContext)blkEncodingCtx, userDataStream);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker((CellComparator)CellComparatorImpl.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
        byte[] onDiskBytes = baosInMemory.toByteArray();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        this.verifySeeking(seeker, readBuffer, batchId);
    }

    private void verifySeeking(DataBlockEncoder.EncodedSeeker encodeSeeker, ByteBuffer encodedData, int batchId) {
        ArrayList kvList = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            kvList.clear();
            encodeSeeker.setCurrentBuffer((ByteBuff)new SingleByteBuff(encodedData));
            KeyValue firstOnRow = KeyValueUtil.createFirstOnRow((byte[])TestPrefixTreeEncoding.getRowKey(batchId, i));
            encodeSeeker.seekToKeyInBlock((Cell)new KeyValue.KeyOnlyKeyValue(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength()), false);
            boolean hasMoreOfEncodeScanner = encodeSeeker.next();
            CollectionBackedScanner collectionScanner = new CollectionBackedScanner(this.kvset);
            boolean hasMoreOfCollectionScanner = collectionScanner.seek((Cell)firstOnRow);
            if (hasMoreOfEncodeScanner != hasMoreOfCollectionScanner) {
                this.dumpInputKVSet();
                Assert.fail((String)("Get error result after seeking " + firstOnRow));
            }
            if (!hasMoreOfEncodeScanner || CellComparatorImpl.COMPARATOR.compare(encodeSeeker.getCell(), collectionScanner.peek()) == 0) continue;
            this.dumpInputKVSet();
            Assert.fail((String)("Expected " + collectionScanner.peek() + " actual " + encodeSeeker.getCell() + ", after seeking " + firstOnRow));
        }
    }

    private void dumpInputKVSet() {
        LOG.info((Object)"Dumping input keyvalue set in error case:");
        for (Cell kv : this.kvset) {
            System.out.println(kv);
        }
    }

    private static void generateFixedTestData(ConcurrentSkipListSet<Cell> kvset, int batchId, boolean useTags, PrefixTreeCodec encoder, HFileBlockEncodingContext blkEncodingCtx, DataOutputStream userDataStream) throws Exception {
        TestPrefixTreeEncoding.generateFixedTestData(kvset, batchId, true, useTags, encoder, blkEncodingCtx, userDataStream);
    }

    private static void generateFixedTestData(ConcurrentSkipListSet<Cell> kvset, int batchId, boolean partial, boolean useTags, PrefixTreeCodec encoder, HFileBlockEncodingContext blkEncodingCtx, DataOutputStream userDataStream) throws Exception {
        for (int i = 0; i < 50; ++i) {
            if (partial && i / 10 % 2 == 1) continue;
            for (int j = 0; j < 20; ++j) {
                KeyValue kv;
                if (!useTags) {
                    kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), TestPrefixTreeEncoding.getValue(batchId, i, j));
                    kvset.add((Cell)kv);
                    continue;
                }
                kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), 0L, TestPrefixTreeEncoding.getValue(batchId, i, j), new Tag[]{new ArrayBackedTag(1, "metaValue1")});
                kvset.add((Cell)kv);
            }
        }
        encoder.startBlockEncoding(blkEncodingCtx, userDataStream);
        for (Cell kv : kvset) {
            encoder.encode(kv, blkEncodingCtx, userDataStream);
        }
        encoder.endBlockEncoding(blkEncodingCtx, userDataStream, null);
    }

    private static void generateRandomTestData(ConcurrentSkipListSet<Cell> kvset, int batchId, boolean useTags, PrefixTreeCodec encoder, HFileBlockEncodingContext blkEncodingCtx, DataOutputStream userDataStream) throws Exception {
        Random random = new Random();
        for (int i = 0; i < 50; ++i) {
            if (random.nextInt(100) < 50) continue;
            for (int j = 0; j < 20; ++j) {
                KeyValue kv;
                if (random.nextInt(100) < 50) continue;
                if (!useTags) {
                    kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), TestPrefixTreeEncoding.getValue(batchId, i, j));
                    kvset.add((Cell)kv);
                    continue;
                }
                kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), 0L, TestPrefixTreeEncoding.getValue(batchId, i, j), new Tag[]{new ArrayBackedTag(1, "metaValue1")});
                kvset.add((Cell)kv);
            }
        }
        encoder.startBlockEncoding(blkEncodingCtx, userDataStream);
        for (Cell kv : kvset) {
            encoder.encode(kv, blkEncodingCtx, userDataStream);
        }
        encoder.endBlockEncoding(blkEncodingCtx, userDataStream, null);
    }

    private static byte[] getRowKey(int batchId, int i) {
        return Bytes.toBytes((String)("batch" + batchId + "_row" + (formatRowNum ? String.format("%04d", i) : Integer.valueOf(i))));
    }

    private static byte[] getQualifier(int j) {
        return Bytes.toBytes((String)("colfdfafhfhsdfhsdfh" + j));
    }

    private static byte[] getValue(int batchId, int i, int j) {
        return Bytes.toBytes((String)("value_for_" + Bytes.toString((byte[])TestPrefixTreeEncoding.getRowKey(batchId, i)) + "_col" + j));
    }
}

