/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestSeekBeforeWithReverseScan {
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private HRegion region;
    private byte[] cfName = Bytes.toBytes((String)"a");
    private byte[] cqName = Bytes.toBytes((String)"b");

    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(this.cfName).setDataBlockEncoding(DataBlockEncoding.FAST_DIFF));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = this.testUtil.getDataTestDir(this.getClass().getSimpleName());
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, this.testUtil.getConfiguration(), (TableDescriptor)htd);
    }

    @After
    public void tearDown() throws Exception {
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        this.testUtil.cleanupTestDir();
    }

    @Test
    public void testReverseScanWithoutPadding() throws Exception {
        byte[] row1 = Bytes.toBytes((String)"a");
        byte[] row2 = Bytes.toBytes((String)"ab");
        byte[] row3 = Bytes.toBytes((String)"b");
        Put put1 = new Put(row1);
        put1.addColumn(this.cfName, this.cqName, HConstants.EMPTY_BYTE_ARRAY);
        Put put2 = new Put(row2);
        put2.addColumn(this.cfName, this.cqName, HConstants.EMPTY_BYTE_ARRAY);
        Put put3 = new Put(row3);
        put3.addColumn(this.cfName, this.cqName, HConstants.EMPTY_BYTE_ARRAY);
        this.region.put(put1);
        this.region.put(put2);
        this.region.put(put3);
        this.region.flush(true);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        scan.setReversed(true);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.addFamily(this.cfName);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
        ArrayList res = new ArrayList();
        int count = 1;
        while (scanner.next(res)) {
            ++count;
        }
        Assert.assertEquals((Object)Bytes.toString((byte[])((Cell)res.get(0)).getRowArray(), (int)((Cell)res.get(0)).getRowOffset(), (int)((Cell)res.get(0)).getRowLength()), (Object)"b");
        Assert.assertEquals((Object)Bytes.toString((byte[])((Cell)res.get(1)).getRowArray(), (int)((Cell)res.get(1)).getRowOffset(), (int)((Cell)res.get(1)).getRowLength()), (Object)"ab");
        Assert.assertEquals((Object)Bytes.toString((byte[])((Cell)res.get(2)).getRowArray(), (int)((Cell)res.get(2)).getRowOffset(), (int)((Cell)res.get(2)).getRowLength()), (Object)"a");
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testReverseScanWithPadding() throws Exception {
        byte[] terminator = new byte[]{-1};
        byte[] row1 = Bytes.add((byte[])this.invert(Bytes.toBytes((String)"a")), (byte[])terminator);
        byte[] row2 = Bytes.add((byte[])this.invert(Bytes.toBytes((String)"ab")), (byte[])terminator);
        byte[] row3 = Bytes.add((byte[])this.invert(Bytes.toBytes((String)"b")), (byte[])terminator);
        Put put1 = new Put(row1);
        put1.addColumn(this.cfName, this.cqName, HConstants.EMPTY_BYTE_ARRAY);
        Put put2 = new Put(row2);
        put2.addColumn(this.cfName, this.cqName, HConstants.EMPTY_BYTE_ARRAY);
        Put put3 = new Put(row3);
        put3.addColumn(this.cfName, this.cqName, HConstants.EMPTY_BYTE_ARRAY);
        this.region.put(put1);
        this.region.put(put2);
        this.region.put(put3);
        this.region.flush(true);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        scan.setReversed(true);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.addFamily(this.cfName);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
        ArrayList res = new ArrayList();
        int count = 1;
        while (scanner.next(res)) {
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    private byte[] invert(byte[] bytes) {
        byte[] newBytes = Arrays.copyOf(bytes, bytes.length);
        for (int i = 0; i < newBytes.length; ++i) {
            newBytes[i] = (byte)(newBytes[i] ^ 0xFF);
        }
        return newBytes;
    }
}

