/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestScannerFromBucketCache {
    private static final Log LOG = LogFactory.getLog(TestScannerFromBucketCache.class);
    @Rule
    public TestName name = new TestName();
    HRegion region = null;
    private HBaseTestingUtility test_util;
    public Configuration conf;
    private final int MAX_VERSIONS = 2;
    byte[] val = new byte[524288];
    private TableName tableName;

    private void setUp(boolean offheap, boolean useBucketCache) throws IOException {
        this.test_util = HBaseTestingUtility.createLocalHTU();
        this.conf = this.test_util.getConfiguration();
        if (useBucketCache) {
            this.conf.setInt("hbase.bucketcache.size", 400);
            if (offheap) {
                this.conf.setStrings("hbase.bucketcache.ioengine", new String[]{"offheap"});
            } else {
                this.conf.setStrings("hbase.bucketcache.ioengine", new String[]{"heap"});
            }
            this.conf.setInt("hbase.bucketcache.writer.threads", 10);
            this.conf.setFloat("hfile.block.cache.size", 0.2f);
            this.conf.setFloat("hbase.regionserver.global.memstore.size", 0.1f);
        }
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info((Object)("Cleaning test directory: " + this.test_util.getDataTestDir()));
        this.test_util.cleanupTestDir();
        CacheConfig.clearGlobalInstances();
    }

    String getName() {
        return this.name.getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicScanWithLRUCache() throws IOException {
        this.setUp(false, false);
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"lrucache");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestScannerFromBucketCache.initHRegion(this.tableName, method, this.conf, this.test_util, new byte[][]{fam1});
        try {
            int i;
            List<Cell> expected = this.insertData(row1, qf1, qf2, fam1, ts1, ts2, ts3, false);
            List<Cell> actual = this.performScan(row1, fam1);
            for (i = 0; i < expected.size(); ++i) {
                Assert.assertFalse((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
            actual = this.performScan(row1, fam1);
            for (i = 0; i < expected.size(); ++i) {
                Assert.assertFalse((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicScanWithOffheapBucketCache() throws IOException {
        this.setUp(true, true);
        byte[] row1 = Bytes.toBytes((String)"row1offheap");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"famoffheap");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestScannerFromBucketCache.initHRegion(this.tableName, method, this.conf, this.test_util, new byte[][]{fam1});
        try {
            int i;
            List<Cell> expected = this.insertData(row1, qf1, qf2, fam1, ts1, ts2, ts3, false);
            List<Cell> actual = this.performScan(row1, fam1);
            for (i = 0; i < expected.size(); ++i) {
                Assert.assertFalse((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
            Thread.sleep(500L);
            actual = this.performScan(row1, fam1);
            for (i = 0; i < expected.size(); ++i) {
                Assert.assertTrue((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicScanWithOffheapBucketCacheWithMBB() throws IOException {
        this.setUp(true, true);
        byte[] row1 = Bytes.toBytes((String)"row1offheap");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"famoffheap");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestScannerFromBucketCache.initHRegion(this.tableName, method, this.conf, this.test_util, new byte[][]{fam1});
        try {
            List<Cell> expected = this.insertData(row1, qf1, qf2, fam1, ts1, ts2, ts3, true);
            List<Cell> actual = this.performScan(row1, fam1);
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertFalse((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
            Thread.sleep(500L);
            Scan scan = new Scan(row1);
            scan.addFamily(fam1);
            scan.setMaxVersions(10);
            actual = new ArrayList<Cell>();
            HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
            boolean hasNext = scanner.next(actual);
            Assert.assertEquals((Object)false, (Object)hasNext);
            for (int i = 0; i < expected.size(); ++i) {
                if (i == 5) continue;
                Assert.assertTrue((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicScanWithOnheapBucketCache() throws IOException {
        this.setUp(false, true);
        byte[] row1 = Bytes.toBytes((String)"row1onheap");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"famonheap");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.region = TestScannerFromBucketCache.initHRegion(this.tableName, method, this.conf, this.test_util, new byte[][]{fam1});
        try {
            int i;
            List<Cell> expected = this.insertData(row1, qf1, qf2, fam1, ts1, ts2, ts3, false);
            List<Cell> actual = this.performScan(row1, fam1);
            for (i = 0; i < expected.size(); ++i) {
                Assert.assertFalse((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
            actual = this.performScan(row1, fam1);
            for (i = 0; i < expected.size(); ++i) {
                Assert.assertFalse((boolean)(actual.get(i) instanceof ByteBufferKeyValue));
                Assert.assertTrue((boolean)PrivateCellUtil.equalsIgnoreMvccVersion((Cell)expected.get(i), (Cell)actual.get(i)));
            }
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
        }
    }

    private List<Cell> insertData(byte[] row1, byte[] qf1, byte[] qf2, byte[] fam1, long ts1, long ts2, long ts3, boolean withVal) throws IOException {
        Put put = null;
        KeyValue kv13 = null;
        KeyValue kv12 = null;
        KeyValue kv11 = null;
        KeyValue kv23 = null;
        KeyValue kv22 = null;
        KeyValue kv21 = null;
        if (!withVal) {
            kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
            kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
            kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
            kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
            kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
            kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        } else {
            kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, this.val);
            kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, this.val);
            kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, this.val);
            kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, this.val);
            kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, this.val);
            kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, this.val);
        }
        put = new Put(row1);
        put.add((Cell)kv13);
        put.add((Cell)kv12);
        put.add((Cell)kv11);
        put.add((Cell)kv23);
        put.add((Cell)kv22);
        put.add((Cell)kv21);
        this.region.put(put);
        this.region.flush(true);
        HStore store = this.region.getStore(fam1);
        while (store.getStorefilesCount() <= 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<Cell> expected = new ArrayList<Cell>();
        expected.add((Cell)kv13);
        expected.add((Cell)kv12);
        expected.add((Cell)kv23);
        expected.add((Cell)kv22);
        return expected;
    }

    private List<Cell> performScan(byte[] row1, byte[] fam1) throws IOException {
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList<Cell> actual = new ArrayList<Cell>();
        HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        Assert.assertEquals((Object)false, (Object)hasNext);
        return actual;
    }

    private static HRegion initHRegion(TableName tableName, String callingMethod, Configuration conf, HBaseTestingUtility test_util, byte[] ... families) throws IOException {
        return TestScannerFromBucketCache.initHRegion(tableName, null, null, callingMethod, conf, test_util, false, families);
    }

    private static HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, HBaseTestingUtility test_util, boolean isReadOnly, byte[] ... families) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        Path logDir = test_util.getDataTestDirOnTestFS(callingMethod + ".log");
        HRegionInfo hri = new HRegionInfo(tableName, startKey, stopKey);
        WAL wal = HBaseTestingUtility.createWal(conf, logDir, (RegionInfo)hri);
        return TestScannerFromBucketCache.initHRegion(tableName, startKey, stopKey, callingMethod, conf, test_util, isReadOnly, Durability.SYNC_WAL, wal, families);
    }

    private static HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, HBaseTestingUtility test_util, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        return test_util.createLocalHRegion(tableName, startKey, stopKey, isReadOnly, durability, wal, families);
    }
}

