/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JVM;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, SmallTests.class})
public class TestNettyIPC
extends AbstractTestIPC {
    @Parameterized.Parameter
    public String eventLoopType;
    private static NioEventLoopGroup NIO;
    private static EpollEventLoopGroup EPOLL;

    @Parameterized.Parameters(name="{index}: EventLoop={0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{"nio"});
        params.add(new Object[]{"perClientNio"});
        if (JVM.isLinux() && JVM.isAmd64()) {
            params.add(new Object[]{"epoll"});
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        NIO = new NioEventLoopGroup();
        if (JVM.isLinux() && JVM.isAmd64()) {
            EPOLL = new EpollEventLoopGroup();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() {
        if (NIO != null) {
            NIO.shutdownGracefully();
        }
        if (EPOLL != null) {
            EPOLL.shutdownGracefully();
        }
    }

    private void setConf(Configuration conf) {
        switch (this.eventLoopType) {
            case "nio": {
                NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)NIO, NioSocketChannel.class);
                break;
            }
            case "epoll": {
                NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)conf, (EventLoopGroup)EPOLL, EpollSocketChannel.class);
                break;
            }
            case "perClientNio": {
                NettyRpcClientConfigHelper.createEventLoopPerClient((Configuration)conf);
                break;
            }
        }
    }

    protected NettyRpcClient createRpcClientNoCodec(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf){

            Codec getCodec() {
                return null;
            }
        };
    }

    protected NettyRpcClient createRpcClient(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf);
    }

    protected NettyRpcClient createRpcClientRTEDuringConnectionSetup(Configuration conf) {
        this.setConf(conf);
        return new NettyRpcClient(conf){

            boolean isTcpNoDelay() {
                throw new RuntimeException("Injected fault");
            }
        };
    }
}

