/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ByteBufferPool;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, SmallTests.class})
public class TestRpcServer {
    @Test
    public void testAllocateByteBuffToReadInto() throws Exception {
        int maxBuffersInPool = 10;
        ByteBufferPool pool = new ByteBufferPool(6144, maxBuffersInPool);
        this.initPoolWithAllBuffers(pool, maxBuffersInPool);
        ByteBuff buff = null;
        Pair pair = RpcServer.allocateByteBuffToReadInto((ByteBufferPool)pool, (int)RpcServer.getMinSizeForReservoirUse((ByteBufferPool)pool), (int)200);
        buff = (ByteBuff)pair.getFirst();
        Assert.assertTrue((boolean)buff.hasArray());
        Assert.assertEquals((long)maxBuffersInPool, (long)pool.getQueueSize());
        Assert.assertNull((Object)pair.getSecond());
        pair = RpcServer.allocateByteBuffToReadInto((ByteBufferPool)pool, (int)RpcServer.getMinSizeForReservoirUse((ByteBufferPool)pool), (int)1024);
        buff = (ByteBuff)pair.getFirst();
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertEquals((long)(maxBuffersInPool - 1), (long)pool.getQueueSize());
        Assert.assertNotNull((Object)pair.getSecond());
        ((RpcServer.CallCleanup)pair.getSecond()).run();
        Assert.assertEquals((long)maxBuffersInPool, (long)pool.getQueueSize());
        pair = RpcServer.allocateByteBuffToReadInto((ByteBufferPool)pool, (int)RpcServer.getMinSizeForReservoirUse((ByteBufferPool)pool), (int)7168);
        buff = (ByteBuff)pair.getFirst();
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof MultiByteBuff));
        ByteBuffer[] bbs = ((MultiByteBuff)buff).getEnclosingByteBuffers();
        Assert.assertEquals((long)2L, (long)bbs.length);
        Assert.assertTrue((boolean)bbs[0].isDirect());
        Assert.assertTrue((boolean)bbs[1].isDirect());
        Assert.assertEquals((long)6144L, (long)bbs[0].limit());
        Assert.assertEquals((long)1024L, (long)bbs[1].limit());
        Assert.assertEquals((long)(maxBuffersInPool - 2), (long)pool.getQueueSize());
        Assert.assertNotNull((Object)pair.getSecond());
        ((RpcServer.CallCleanup)pair.getSecond()).run();
        Assert.assertEquals((long)maxBuffersInPool, (long)pool.getQueueSize());
        pair = RpcServer.allocateByteBuffToReadInto((ByteBufferPool)pool, (int)RpcServer.getMinSizeForReservoirUse((ByteBufferPool)pool), (int)6344);
        buff = (ByteBuff)pair.getFirst();
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof MultiByteBuff));
        bbs = ((MultiByteBuff)buff).getEnclosingByteBuffers();
        Assert.assertEquals((long)2L, (long)bbs.length);
        Assert.assertTrue((boolean)bbs[0].isDirect());
        Assert.assertFalse((boolean)bbs[1].isDirect());
        Assert.assertEquals((long)6144L, (long)bbs[0].limit());
        Assert.assertEquals((long)200L, (long)bbs[1].limit());
        Assert.assertEquals((long)(maxBuffersInPool - 1), (long)pool.getQueueSize());
        Assert.assertNotNull((Object)pair.getSecond());
        ((RpcServer.CallCleanup)pair.getSecond()).run();
        Assert.assertEquals((long)maxBuffersInPool, (long)pool.getQueueSize());
        ByteBuffer[] buffers = new ByteBuffer[maxBuffersInPool - 1];
        for (int i = 0; i < maxBuffersInPool - 1; ++i) {
            buffers[i] = pool.getBuffer();
        }
        pair = RpcServer.allocateByteBuffToReadInto((ByteBufferPool)pool, (int)RpcServer.getMinSizeForReservoirUse((ByteBufferPool)pool), (int)20480);
        buff = (ByteBuff)pair.getFirst();
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof MultiByteBuff));
        bbs = ((MultiByteBuff)buff).getEnclosingByteBuffers();
        Assert.assertEquals((long)2L, (long)bbs.length);
        Assert.assertTrue((boolean)bbs[0].isDirect());
        Assert.assertFalse((boolean)bbs[1].isDirect());
        Assert.assertEquals((long)6144L, (long)bbs[0].limit());
        Assert.assertEquals((long)14336L, (long)bbs[1].limit());
        Assert.assertEquals((long)0L, (long)pool.getQueueSize());
        Assert.assertNotNull((Object)pair.getSecond());
        ((RpcServer.CallCleanup)pair.getSecond()).run();
        Assert.assertEquals((long)1L, (long)pool.getQueueSize());
        pool.getBuffer();
        pair = RpcServer.allocateByteBuffToReadInto((ByteBufferPool)pool, (int)RpcServer.getMinSizeForReservoirUse((ByteBufferPool)pool), (int)7168);
        buff = (ByteBuff)pair.getFirst();
        Assert.assertTrue((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof SingleByteBuff));
        Assert.assertEquals((long)7168L, (long)((SingleByteBuff)buff).getEnclosingByteBuffer().limit());
        Assert.assertNull((Object)pair.getSecond());
    }

    private void initPoolWithAllBuffers(ByteBufferPool pool, int maxBuffersInPool) {
        ByteBuffer[] buffers = new ByteBuffer[maxBuffersInPool];
        for (int i = 0; i < maxBuffersInPool; ++i) {
            buffers[i] = pool.getBuffer();
        }
        for (ByteBuffer buf : buffers) {
            pool.putbackBuffer(buf);
        }
    }
}

