/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterFailoverBalancerPersistence {
    @Test(timeout=240000L)
    public void testMasterFailoverBalancerPersistence() throws Exception {
        int NUM_MASTERS = 3;
        boolean NUM_RS = true;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(3, 1);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster active = cluster.getMaster();
        ClusterStatus clusterStatus = active.getClusterStatus();
        Assert.assertTrue((boolean)clusterStatus.isBalancerOn());
        active = this.killActiveAndWaitForNewActive(cluster);
        clusterStatus = active.getClusterStatus();
        Assert.assertTrue((boolean)clusterStatus.isBalancerOn());
        active.balanceSwitch(false);
        active = this.killActiveAndWaitForNewActive(cluster);
        clusterStatus = active.getClusterStatus();
        Assert.assertFalse((boolean)clusterStatus.isBalancerOn());
        TEST_UTIL.shutdownMiniCluster();
    }

    private HMaster killActiveAndWaitForNewActive(MiniHBaseCluster cluster) throws InterruptedException, IOException {
        int activeIndex = this.getActiveMasterIndex(cluster);
        HMaster active = cluster.getMaster();
        cluster.stopMaster(activeIndex);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster newActive = cluster.getMaster();
        Assert.assertFalse((active == newActive ? 1 : 0) != 0);
        return newActive;
    }

    private int getActiveMasterIndex(MiniHBaseCluster cluster) throws MasterNotRunningException {
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            return i;
        }
        throw new MasterNotRunningException();
    }
}

