/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterShutdown {
    private static final Log LOG = LogFactory.getLog(TestMasterShutdown.class);

    @Test(timeout=120000L)
    public void testMasterShutdown() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility htu = new HBaseTestingUtility(conf);
        htu.startMiniCluster(3, 3);
        MiniHBaseCluster cluster = htu.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            active = masterThreads.get(i).getMaster();
            break;
        }
        Assert.assertNotNull(active);
        ClusterStatus status = active.getClusterStatus();
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)2L, (long)status.getBackupMasters().size());
        active.shutdown();
        for (int i = 2; i >= 0; --i) {
            cluster.waitOnMaster(i);
        }
        Assert.assertEquals((long)0L, (long)masterThreads.size());
        htu.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testMasterShutdownBeforeStartingAnyRegionServer() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = false;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.ipc.client.failed.servers.expiry", 200);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        final HBaseTestingUtility util = new HBaseTestingUtility(conf);
        util.startMiniDFSCluster(3);
        util.startMiniZKCluster();
        util.createRootDir();
        final LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 0, HMaster.class, MiniHBaseCluster.MiniHBaseClusterRegionServer.class);
        boolean MASTER_INDEX = false;
        JVMClusterUtil.MasterThread master = (JVMClusterUtil.MasterThread)cluster.getMasters().get(0);
        master.start();
        LOG.info((Object)("Called master start on " + master.getName()));
        Thread shutdownThread = new Thread("Shutdown-Thread"){

            @Override
            public void run() {
                LOG.info((Object)"Before call to shutdown master");
                try {
                    try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());
                         Admin admin = connection.getAdmin();){
                        admin.shutdown();
                    }
                    LOG.info((Object)"After call to shutdown master");
                    cluster.waitOnMaster(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        shutdownThread.start();
        LOG.info((Object)("Called master join on " + master.getName()));
        master.join();
        shutdownThread.join();
        List masterThreads = cluster.getMasters();
        Assert.assertEquals((long)0L, (long)masterThreads.size());
        util.shutdownMiniZKCluster();
        util.shutdownMiniDFSCluster();
        util.cleanupTestDir();
    }
}

