/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterWalManager {
    private static final Log LOG = LogFactory.getLog(TestMasterWalManager.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRemoveStaleRecoveringRegionsDuringMasterInitialization() throws Exception {
        if (!UTIL.getConfiguration().getBoolean("hbase.master.distributed.log.replay", false)) {
            return;
        }
        LOG.info((Object)"Starting testRemoveStaleRecoveringRegionsDuringMasterInitialization");
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterWalManager mwm = master.getMasterWalManager();
        String failedRegion = "failedRegoin1";
        String staleRegion = "staleRegion";
        ServerName inRecoveryServerName = ServerName.valueOf((String)"mgr,1,1");
        ServerName previouselyFaildServerName = ServerName.valueOf((String)"previous,1,1");
        String walPath = "/hbase/data/.logs/" + inRecoveryServerName.getServerName() + "-splitting/test";
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(UTIL);
        zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)zkw, (String)walPath), new SplitLogTask.Owned(inRecoveryServerName).toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String staleRegionPath = ZKUtil.joinZNode((String)zkw.znodePaths.recoveringRegionsZNode, (String)staleRegion);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)staleRegionPath);
        String inRecoveringRegionPath = ZKUtil.joinZNode((String)zkw.znodePaths.recoveringRegionsZNode, (String)failedRegion);
        inRecoveringRegionPath = ZKUtil.joinZNode((String)inRecoveringRegionPath, (String)inRecoveryServerName.getServerName());
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)inRecoveringRegionPath);
        HashSet<ServerName> servers = new HashSet<ServerName>();
        servers.add(previouselyFaildServerName);
        mwm.removeStaleRecoveringRegionsFromZK(servers);
        Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)staleRegionPath) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)inRecoveringRegionPath) != -1 ? 1 : 0) != 0);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)zkw, (String)zkw.znodePaths.recoveringRegionsZNode);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)zkw, (String)zkw.znodePaths.splitLogZNode);
        zkw.close();
    }
}

