/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTableStateManager {
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testUpgradeFromZk() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.TEST_UTIL.startMiniCluster(2, 1);
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        ZooKeeperWatcher watcher = this.TEST_UTIL.getZooKeeperWatcher();
        this.setTableStateInZK(watcher, tableName, ZooKeeperProtos.DeprecatedTableState.State.DISABLED);
        this.TEST_UTIL.restartHBaseCluster(1);
        HMaster master = this.TEST_UTIL.getHBaseCluster().getMaster();
        Assert.assertEquals((Object)master.getTableStateManager().getTableState(tableName), (Object)TableState.State.DISABLED);
    }

    private void setTableStateInZK(ZooKeeperWatcher watcher, TableName tableName, ZooKeeperProtos.DeprecatedTableState.State state) throws KeeperException, IOException {
        String znode = ZKUtil.joinZNode((String)watcher.znodePaths.tableZNode, (String)tableName.getNameAsString());
        if (ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)znode) == -1) {
            ZKUtil.createAndFailSilent((ZooKeeperWatcher)watcher, (String)znode);
        }
        ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
        builder.setState(state);
        byte[] data = ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
        ZKUtil.setData((ZooKeeperWatcher)watcher, (String)znode, (byte[])data);
    }
}

