/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.junit.Assert;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AssignmentTestingUtil {
    private static final Log LOG = LogFactory.getLog(AssignmentTestingUtil.class);

    private AssignmentTestingUtil() {
    }

    public static void waitForRegionToBeInTransition(HBaseTestingUtility util, RegionInfo hri) throws Exception {
        while (!AssignmentTestingUtil.getMaster(util).getAssignmentManager().getRegionStates().isRegionInTransition(hri)) {
            Threads.sleep((long)10L);
        }
    }

    public static void waitForRsToBeDead(final HBaseTestingUtility util, final ServerName serverName) throws Exception {
        util.waitFor(60000L, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() {
                return AssignmentTestingUtil.getMaster(util).getServerManager().isServerDead(serverName);
            }

            public String explainFailure() {
                return "Server " + serverName + " is not dead";
            }
        });
    }

    public static void stopRs(HBaseTestingUtility util, ServerName serverName) throws Exception {
        LOG.info((Object)("STOP REGION SERVER " + serverName));
        util.getMiniHBaseCluster().stopRegionServer(serverName);
        AssignmentTestingUtil.waitForRsToBeDead(util, serverName);
    }

    public static void killRs(HBaseTestingUtility util, ServerName serverName) throws Exception {
        LOG.info((Object)("KILL REGION SERVER " + serverName));
        util.getMiniHBaseCluster().killRegionServer(serverName);
        AssignmentTestingUtil.waitForRsToBeDead(util, serverName);
    }

    public static void crashRs(HBaseTestingUtility util, ServerName serverName, boolean kill) throws Exception {
        if (kill) {
            AssignmentTestingUtil.killRs(util, serverName);
        } else {
            AssignmentTestingUtil.stopRs(util, serverName);
        }
    }

    public static ServerName crashRsWithRegion(HBaseTestingUtility util, RegionInfo hri, boolean kill) throws Exception {
        ServerName serverName = AssignmentTestingUtil.getServerHoldingRegion(util, hri);
        AssignmentTestingUtil.crashRs(util, serverName, kill);
        return serverName;
    }

    public static ServerName getServerHoldingRegion(HBaseTestingUtility util, RegionInfo hri) throws Exception {
        ServerName serverName = util.getMiniHBaseCluster().getServerHoldingRegion(hri.getTable(), hri.getRegionName());
        ServerName amServerName = AssignmentTestingUtil.getMaster(util).getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        Assert.assertEquals((Object)amServerName, (Object)serverName);
        Assert.assertEquals((Object)true, (Object)AssignmentTestingUtil.getMaster(util).getServerManager().isServerOnline(serverName));
        return serverName;
    }

    public static boolean isServerHoldingMeta(HBaseTestingUtility util, ServerName serverName) throws Exception {
        for (RegionInfo hri : AssignmentTestingUtil.getMetaRegions(util)) {
            if (!serverName.equals((Object)AssignmentTestingUtil.getServerHoldingRegion(util, hri))) continue;
            return true;
        }
        return false;
    }

    public static Set<RegionInfo> getMetaRegions(HBaseTestingUtility util) {
        return AssignmentTestingUtil.getMaster(util).getAssignmentManager().getMetaRegionSet();
    }

    private static HMaster getMaster(HBaseTestingUtility util) {
        return util.getMiniHBaseCluster().getMaster();
    }
}

