/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.FavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.LoadOnlyFavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestFavoredStochasticBalancerPickers
extends BalancerTestBase {
    private static final Log LOG = LogFactory.getLog(TestFavoredStochasticBalancerPickers.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int SLAVES = 6;
    private static final int REGIONS = 18;
    private static Configuration conf;
    private Admin admin;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.master.loadbalancer.class", LoadOnlyFavoredStochasticBalancer.class, LoadBalancer.class);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 30000L);
        conf.setInt("hbase.master.balancer.stochastic.moveCost", 0);
        conf.setBoolean("hbase.master.balancer.stochastic.execute.maxSteps", true);
        conf.set("hbase.balancer.tablesOnMaster", "none");
    }

    @Before
    public void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(6);
        TEST_UTIL.getDFSCluster().waitClusterUp();
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster(120000L);
        this.admin = TEST_UTIL.getAdmin();
        this.admin.setBalancerRunning(false, true);
    }

    @After
    public void stopCluster() throws Exception {
        TEST_UTIL.cleanupTestDir();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Ignore
    @Test
    public void testPickers() throws Exception {
        TableName tableName = TableName.valueOf((String)"testPickers");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 18);
        TEST_UTIL.loadTable(this.admin.getConnection().getTable(tableName), HConstants.CATALOG_FAMILY);
        this.admin.flush(tableName);
        ServerName masterServerName = TEST_UTIL.getMiniHBaseCluster().getServerHoldingMeta();
        final ServerName mostLoadedServer = this.getRSWithMaxRegions(Lists.newArrayList((Object[])new ServerName[]{masterServerName}));
        Assert.assertNotNull((Object)mostLoadedServer);
        int numRegions = this.admin.getOnlineRegions(mostLoadedServer).size();
        ServerName source = this.getRSWithMaxRegions(Lists.newArrayList((Object[])new ServerName[]{masterServerName, mostLoadedServer}));
        Assert.assertNotNull((Object)source);
        int regionsToMove = this.admin.getOnlineRegions(source).size() / 2;
        List hris = this.admin.getRegions(source);
        for (int i = 0; i < regionsToMove; ++i) {
            this.admin.move(((RegionInfo)hris.get(i)).getEncodedNameAsBytes(), Bytes.toBytes((String)mostLoadedServer.getServerName()));
            LOG.info((Object)("Moving region: " + ((RegionInfo)hris.get(i)).getRegionNameAsString() + " to " + mostLoadedServer));
        }
        final int finalRegions = numRegions + regionsToMove;
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                int numRegions = TEST_UTIL.getAdmin().getOnlineRegions(mostLoadedServer).size();
                return numRegions == finalRegions;
            }
        });
        TEST_UTIL.getHBaseCluster().startRegionServerAndWait(60000L);
        HashMap serverAssignments = Maps.newHashMap();
        ClusterStatus status = this.admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS));
        for (ServerName sn : status.getServers()) {
            if (ServerName.isSameAddress((ServerName)sn, (ServerName)masterServerName)) continue;
            serverAssignments.put(sn, this.admin.getRegions(sn));
        }
        RegionLocationFinder regionFinder = new RegionLocationFinder();
        regionFinder.setClusterStatus(this.admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)));
        regionFinder.setConf(conf);
        regionFinder.setServices((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster((Map)serverAssignments, null, regionFinder, new RackManager(conf));
        LoadOnlyFavoredStochasticBalancer balancer = (LoadOnlyFavoredStochasticBalancer)TEST_UTIL.getMiniHBaseCluster().getMaster().getLoadBalancer();
        FavoredNodesManager fnm = TEST_UTIL.getMiniHBaseCluster().getMaster().getFavoredNodesManager();
        cluster.sortServersByRegionCount();
        Object[] servers = cluster.serverIndicesSortedByRegionCount;
        LOG.info((Object)("Servers sorted by region count:" + Arrays.toString(servers)));
        LOG.info((Object)("Cluster dump: " + cluster));
        if (!mostLoadedServer.equals((Object)cluster.servers[(Integer)servers[servers.length - 1]])) {
            LOG.error((Object)("Most loaded server: " + mostLoadedServer + " does not match: " + cluster.servers[(Integer)servers[servers.length - 1]]));
        }
        Assert.assertEquals((Object)mostLoadedServer, (Object)cluster.servers[(Integer)servers[servers.length - 1]]);
        FavoredStochasticBalancer.FavoredNodeLoadPicker loadPicker = new FavoredStochasticBalancer.FavoredNodeLoadPicker((FavoredStochasticBalancer)balancer);
        boolean userRegionPicked = false;
        for (int i = 0; i < 100 && !userRegionPicked; ++i) {
            BaseLoadBalancer.Cluster.Action action = loadPicker.generate(cluster);
            if (action.type != BaseLoadBalancer.Cluster.Action.Type.MOVE_REGION) continue;
            BaseLoadBalancer.Cluster.MoveRegionAction moveRegionAction = (BaseLoadBalancer.Cluster.MoveRegionAction)action;
            RegionInfo region = cluster.regions[moveRegionAction.region];
            Assert.assertNotEquals((long)-1L, (long)moveRegionAction.toServer);
            ServerName destinationServer = cluster.servers[moveRegionAction.toServer];
            Assert.assertEquals((Object)cluster.servers[moveRegionAction.fromServer], (Object)mostLoadedServer);
            if (region.getTable().isSystemTable()) continue;
            List favNodes = fnm.getFavoredNodes(region);
            Assert.assertTrue((boolean)favNodes.contains(ServerName.valueOf((String)destinationServer.getHostAndPort(), (long)-1L)));
            userRegionPicked = true;
        }
        Assert.assertTrue((String)"load picker did not pick expected regions in 100 iterations.", (boolean)userRegionPicked);
    }

    private ServerName getRSWithMaxRegions(ArrayList<ServerName> excludeNodes) throws IOException {
        int maxRegions = 0;
        ServerName maxLoadedServer = null;
        for (ServerName sn : this.admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers()) {
            if (this.admin.getOnlineRegions(sn).size() <= maxRegions || excludeNodes != null && this.doesMatchExcludeNodes(excludeNodes, sn)) continue;
            maxRegions = this.admin.getOnlineRegions(sn).size();
            maxLoadedServer = sn;
        }
        return maxLoadedServer;
    }

    private boolean doesMatchExcludeNodes(ArrayList<ServerName> excludeNodes, ServerName sn) {
        for (ServerName excludeSN : excludeNodes) {
            if (!ServerName.isSameAddress((ServerName)sn, (ServerName)excludeSN)) continue;
            return true;
        }
        return false;
    }
}

