/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MediumTests.class})
public class TestRegionsOnMasterOptions {
    private static final Log LOG = LogFactory.getLog(TestRegionsOnMasterOptions.class);
    @Rule
    public TestName name = new TestName();
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration c;
    private String tablesOnMasterOldValue;
    private String systemTablesOnMasterOldValue;
    private static final int SLAVES = 3;
    private static final int MASTERS = 2;
    private static final int REGIONS = 12;
    private static final int SYSTEM_REGIONS = 2;

    @Before
    public void setup() {
        this.c = TEST_UTIL.getConfiguration();
        this.tablesOnMasterOldValue = this.c.get("hbase.balancer.tablesOnMaster");
        this.systemTablesOnMasterOldValue = this.c.get("hbase.balancer.tablesOnMaster.systemTablesOnly");
    }

    @After
    public void tearDown() {
        this.unset("hbase.balancer.tablesOnMaster", this.tablesOnMasterOldValue);
        this.unset("hbase.balancer.tablesOnMaster.systemTablesOnly", this.systemTablesOnMasterOldValue);
    }

    private void unset(String key, String value) {
        if (value == null) {
            this.c.unset(key);
        } else {
            this.c.set(key, value);
        }
    }

    @Test
    public void testRegionsOnAllServers() throws Exception {
        this.c.setBoolean("hbase.balancer.tablesOnMaster", true);
        this.c.setBoolean("hbase.balancer.tablesOnMaster.systemTablesOnly", false);
        int rsCount = 3;
        this.checkBalance(rsCount, rsCount);
    }

    @Test
    public void testNoRegionOnMaster() throws Exception {
        this.c.setBoolean("hbase.balancer.tablesOnMaster", false);
        this.c.setBoolean("hbase.balancer.tablesOnMaster.systemTablesOnly", false);
        int rsCount = 4;
        this.checkBalance(0, rsCount);
    }

    @Test
    public void testSystemTablesOnMaster() throws Exception {
        this.c.setBoolean("hbase.balancer.tablesOnMaster", true);
        this.c.setBoolean("hbase.balancer.tablesOnMaster.systemTablesOnly", true);
        this.checkBalance(2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBalance(int masterCount, int rsCount) throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.startMiniCluster(2, 3);
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        try {
            Table t = TEST_UTIL.createMultiRegionTable(tn, HConstants.CATALOG_FAMILY, 12);
            LOG.info((Object)("Server: " + cluster.getMaster().getServerManager().getOnlineServersList()));
            List regions = cluster.getMaster().getRegions();
            int mActualCount = regions.size();
            if (masterCount == 0 || masterCount == 2) {
                Assert.assertEquals((long)masterCount, (long)mActualCount);
            } else {
                this.checkCount(masterCount, mActualCount);
            }
            for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
                regions = rst.getRegionServer().getRegions();
                int rsActualCount = regions.size();
                this.checkCount(rsActualCount, rsCount);
            }
            HMaster oldMaster = cluster.getMaster();
            cluster.killMaster(oldMaster.getServerName());
            oldMaster.join();
            while (cluster.getMaster() == null || cluster.getMaster().getServerName().equals((Object)oldMaster.getServerName())) {
                Threads.sleep((long)10L);
            }
            while (!cluster.getMaster().isInitialized()) {
                Threads.sleep((long)10L);
            }
            LOG.info((Object)"Cluster is up; running balancer");
            cluster.getMaster().balance();
            regions = cluster.getMaster().getRegions();
            int mNewActualCount = regions.size();
            if (masterCount == 0 || masterCount == 2) {
                Assert.assertEquals((long)masterCount, (long)mNewActualCount);
            }
        }
        finally {
            LOG.info((Object)"Running shutdown of cluster");
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    private void checkCount(int actual, int expected) {
        Assert.assertTrue((String)("Actual=" + actual + ", expected=" + expected), (actual >= expected - 2 && actual <= expected + 2 ? 1 : 0) != 0);
    }
}

