/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientZKImpl;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestLogsCleaner {
    private static final Log LOG = LogFactory.getLog(TestLogsCleaner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLogCleaning() throws Exception {
        Path fileName;
        int i;
        Configuration conf = TEST_UTIL.getConfiguration();
        long ttlWAL = 2000L;
        long ttlProcedureWAL = 4000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttlWAL);
        conf.setLong("hbase.master.procedurewalcleaner.ttl", ttlProcedureWAL);
        Replication.decorateMasterConfiguration((Configuration)conf);
        DummyServer server = new DummyServer();
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)server, server.getZooKeeper()));
        repQueues.init(server.getServerName().toString());
        Path oldLogDir = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
        Path oldProcedureWALDir = new Path(oldLogDir, "masterProcedureWALs");
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), "UTF8");
        FileSystem fs = FileSystem.get((Configuration)conf);
        long now = System.currentTimeMillis();
        fs.delete(oldLogDir, true);
        fs.mkdirs(oldLogDir);
        fs.createNewFile(new Path(oldLogDir, "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + ".a"));
        for (i = 1; i < 6; ++i) {
            fileName = new Path(oldProcedureWALDir, String.format("pv-%020d.log", i));
            fs.createNewFile(fileName);
        }
        Thread.sleep(ttlProcedureWAL - ttlWAL);
        for (i = 1; i < 31; ++i) {
            fileName = new Path(oldLogDir, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 1) continue;
            repQueues.addLog(fakeMachineName, fileName.getName());
            LOG.info((Object)("Replication log file: " + fileName));
        }
        for (i = 6; i < 11; ++i) {
            fileName = new Path(oldProcedureWALDir, String.format("pv-%020d.log", i));
            fs.createNewFile(fileName);
        }
        Thread.sleep(ttlWAL);
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + now));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + (now + ttlWAL)));
        for (FileStatus stat : fs.listStatus(oldLogDir)) {
            LOG.info((Object)stat.getPath().toString());
        }
        Assert.assertEquals((long)35L, (long)fs.listStatus(oldLogDir).length);
        Assert.assertEquals((long)10L, (long)fs.listStatus(oldProcedureWALDir).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, oldLogDir);
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, () -> 6 == fs.listStatus(oldLogDir).length);
        TEST_UTIL.waitFor(1000L, () -> 5 == fs.listStatus(oldProcedureWALDir).length);
        for (FileStatus file : fs.listStatus(oldLogDir)) {
            LOG.debug((Object)("Kept log file in oldWALs: " + file.getPath().getName()));
        }
        for (FileStatus file : fs.listStatus(oldProcedureWALDir)) {
            LOG.debug((Object)("Kept log file in masterProcedureWALs: " + file.getPath().getName()));
        }
    }

    @Test(timeout=5000L)
    public void testZnodeCversionChange() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        cleaner.setConf(conf);
        ReplicationQueuesClientZKImpl rqcMock = (ReplicationQueuesClientZKImpl)Mockito.mock(ReplicationQueuesClientZKImpl.class);
        Mockito.when((Object)rqcMock.getQueuesZNodeCversion()).thenReturn((Object)1, (Object[])new Integer[]{2, 3, 4});
        Field rqc = ReplicationLogCleaner.class.getDeclaredField("replicationQueues");
        rqc.setAccessible(true);
        rqc.set(cleaner, rqcMock);
        cleaner.getDeletableFiles(new LinkedList());
    }

    @Test
    public void testZooKeeperAbort() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        ArrayList dummyFiles = Lists.newArrayList((Object[])new FileStatus[]{new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log2"))});
        try (FaultyZooKeeperWatcher faultyZK = new FaultyZooKeeperWatcher(conf, "testZooKeeperAbort-faulty", null);){
            faultyZK.init();
            cleaner.setConf(conf, (ZooKeeperWatcher)faultyZK);
            cleaner.preClean();
            Iterable toDelete = cleaner.getDeletableFiles((Iterable)dummyFiles);
            Assert.assertFalse((boolean)toDelete.iterator().hasNext());
            Assert.assertFalse((boolean)cleaner.isStopped());
        }
        cleaner = new ReplicationLogCleaner();
        var5_5 = null;
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            cleaner.preClean();
            Iterable filesToDelete = cleaner.getDeletableFiles((Iterable)dummyFiles);
            Iterator iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log1"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log2"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    static class FaultyZooKeeperWatcher
    extends ZooKeeperWatcher {
        private RecoverableZooKeeper zk;

        public FaultyZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
            super(conf, identifier, abortable);
        }

        public void init() throws Exception {
            this.zk = (RecoverableZooKeeper)Mockito.spy((Object)super.getRecoverableZooKeeper());
            ((RecoverableZooKeeper)Mockito.doThrow((Throwable)new KeeperException.ConnectionLossException()).when((Object)this.zk)).getData("/hbase/replication/rs", null, new Stat());
        }

        public RecoverableZooKeeper getRecoverableZooKeeper() {
            return this.zk;
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }
    }
}

