/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSimpleRegionNormalizer {
    private static final Log LOG = LogFactory.getLog(TestSimpleRegionNormalizer.class);
    private static RegionNormalizer normalizer;
    private static MasterServices masterServices;
    private static MasterRpcServices masterRpcServices;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        normalizer = new SimpleRegionNormalizer();
    }

    @Test
    public void testNoNormalizationForMetaTable() throws HBaseIOException {
        TableName testTable = TableName.META_TABLE_NAME;
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(testTable);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testNoNormalizationIfTooFewRegions() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"aaa")).setEndKey(Bytes.toBytes((String)"bbb")).build();
        RegionInfo2.add(hri1);
        regionSizes.put(hri1.getRegionName(), 10);
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"bbb")).setEndKey(Bytes.toBytes((String)"ccc")).build();
        RegionInfo2.add(hri2);
        regionSizes.put(hri2.getRegionName(), 15);
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(tableName);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testNoNormalizationOnNormalizedCluster() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"aaa")).setEndKey(Bytes.toBytes((String)"bbb")).build();
        RegionInfo2.add(hri1);
        regionSizes.put(hri1.getRegionName(), 10);
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"bbb")).setEndKey(Bytes.toBytes((String)"ccc")).build();
        RegionInfo2.add(hri2);
        regionSizes.put(hri2.getRegionName(), 15);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ccc")).setEndKey(Bytes.toBytes((String)"ddd")).build();
        RegionInfo2.add(hri3);
        regionSizes.put(hri3.getRegionName(), 8);
        RegionInfo hri4 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ddd")).setEndKey(Bytes.toBytes((String)"eee")).build();
        regionSizes.put(hri4.getRegionName(), 10);
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(tableName);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testMergeOfSmallRegions() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"aaa")).setEndKey(Bytes.toBytes((String)"bbb")).build();
        RegionInfo2.add(hri1);
        regionSizes.put(hri1.getRegionName(), 15);
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"bbb")).setEndKey(Bytes.toBytes((String)"ccc")).build();
        RegionInfo2.add(hri2);
        regionSizes.put(hri2.getRegionName(), 5);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ccc")).setEndKey(Bytes.toBytes((String)"ddd")).build();
        RegionInfo2.add(hri3);
        regionSizes.put(hri3.getRegionName(), 5);
        RegionInfo hri4 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ddd")).setEndKey(Bytes.toBytes((String)"eee")).build();
        RegionInfo2.add(hri4);
        regionSizes.put(hri4.getRegionName(), 15);
        RegionInfo hri5 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"eee")).setEndKey(Bytes.toBytes((String)"fff")).build();
        RegionInfo2.add(hri5);
        regionSizes.put(hri5.getRegionName(), 16);
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(tableName);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)hri2, (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)hri3, (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testMergeOfSecondSmallestRegions() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"aaa")).setEndKey(Bytes.toBytes((String)"bbb")).build();
        RegionInfo2.add(hri1);
        regionSizes.put(hri1.getRegionName(), 1);
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"bbb")).setEndKey(Bytes.toBytes((String)"ccc")).build();
        RegionInfo2.add(hri2);
        regionSizes.put(hri2.getRegionName(), 10000);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ccc")).setEndKey(Bytes.toBytes((String)"ddd")).build();
        RegionInfo2.add(hri3);
        regionSizes.put(hri3.getRegionName(), 10000);
        RegionInfo hri4 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ddd")).setEndKey(Bytes.toBytes((String)"eee")).build();
        RegionInfo2.add(hri4);
        regionSizes.put(hri4.getRegionName(), 10000);
        RegionInfo hri5 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"eee")).setEndKey(Bytes.toBytes((String)"fff")).build();
        RegionInfo2.add(hri5);
        regionSizes.put(hri5.getRegionName(), 2700);
        RegionInfo hri6 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"fff")).setEndKey(Bytes.toBytes((String)"ggg")).build();
        RegionInfo2.add(hri6);
        regionSizes.put(hri6.getRegionName(), 2700);
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(tableName);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)hri5, (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)hri6, (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testMergeOfSmallNonAdjacentRegions() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"aaa")).setEndKey(Bytes.toBytes((String)"bbb")).build();
        RegionInfo2.add(hri1);
        regionSizes.put(hri1.getRegionName(), 15);
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"bbb")).setEndKey(Bytes.toBytes((String)"ccc")).build();
        RegionInfo2.add(hri2);
        regionSizes.put(hri2.getRegionName(), 5);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ccc")).setEndKey(Bytes.toBytes((String)"ddd")).build();
        RegionInfo2.add(hri3);
        regionSizes.put(hri3.getRegionName(), 16);
        RegionInfo hri4 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ddd")).setEndKey(Bytes.toBytes((String)"eee")).build();
        RegionInfo2.add(hri4);
        regionSizes.put(hri4.getRegionName(), 15);
        RegionInfo hri5 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ddd")).setEndKey(Bytes.toBytes((String)"eee")).build();
        RegionInfo2.add(hri4);
        regionSizes.put(hri5.getRegionName(), 5);
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(tableName);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testSplitOfLargeRegion() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"aaa")).setEndKey(Bytes.toBytes((String)"bbb")).build();
        RegionInfo2.add(hri1);
        regionSizes.put(hri1.getRegionName(), 8);
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"bbb")).setEndKey(Bytes.toBytes((String)"ccc")).build();
        RegionInfo2.add(hri2);
        regionSizes.put(hri2.getRegionName(), 6);
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ccc")).setEndKey(Bytes.toBytes((String)"ddd")).build();
        RegionInfo2.add(hri3);
        regionSizes.put(hri3.getRegionName(), 10);
        RegionInfo hri4 = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((String)"ddd")).setEndKey(Bytes.toBytes((String)"eee")).build();
        RegionInfo2.add(hri4);
        regionSizes.put(hri4.getRegionName(), 30);
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = normalizer.computePlanForTable(tableName);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof SplitNormalizationPlan));
        Assert.assertEquals((Object)hri4, (Object)((SplitNormalizationPlan)plan).getRegionInfo());
    }

    protected void setupMocksForNormalizer(Map<byte[], Integer> regionSizes, List<RegionInfo> RegionInfo2) {
        masterServices = (MasterServices)Mockito.mock(MasterServices.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        masterRpcServices = (MasterRpcServices)Mockito.mock(MasterRpcServices.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ServerName sn = ServerName.valueOf((String)"localhost", (int)0, (long)1L);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable((TableName)Matchers.any(TableName.class))).thenReturn(RegionInfo2);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion((RegionInfo)Matchers.any(RegionInfo.class))).thenReturn((Object)sn);
        for (Map.Entry<byte[], Integer> region : regionSizes.entrySet()) {
            RegionLoad regionLoad = (RegionLoad)Mockito.mock(RegionLoad.class);
            Mockito.when((Object)regionLoad.getName()).thenReturn((Object)region.getKey());
            Mockito.when((Object)regionLoad.getStorefileSizeMB()).thenReturn((Object)region.getValue());
            Mockito.when(masterServices.getServerManager().getLoad(sn).getRegionsLoad().get(region.getKey())).thenReturn((Object)regionLoad);
        }
        try {
            Mockito.when((Object)masterRpcServices.isSplitOrMergeEnabled((RpcController)Matchers.any(RpcController.class), (MasterProtos.IsSplitOrMergeEnabledRequest)Matchers.any(MasterProtos.IsSplitOrMergeEnabledRequest.class))).thenReturn((Object)MasterProtos.IsSplitOrMergeEnabledResponse.newBuilder().setEnabled(true).build());
        }
        catch (ServiceException se) {
            LOG.debug((Object)"error setting isSplitOrMergeEnabled switch", (Throwable)se);
        }
        normalizer.setMasterServices(masterServices);
        normalizer.setMasterRpcServices(masterRpcServices);
    }
}

