/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCreateTableProcedure
extends TestTableDDLProcedureBase {
    private static final Log LOG = LogFactory.getLog(TestCreateTableProcedure.class);
    private static final String F1 = "f1";
    private static final String F2 = "f2";
    @Rule
    public TestName name = new TestName();

    @Test(timeout=60000L)
    public void testSimpleCreate() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = null;
        this.testSimpleCreate(tableName, splitKeys);
    }

    @Test(timeout=60000L)
    public void testSimpleCreateWithSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        this.testSimpleCreate(tableName, splitKeys);
    }

    private void testSimpleCreate(TableName tableName, byte[][] splitKeys) throws Exception {
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, F1, F2);
        MasterProcedureTestingUtility.validateTableCreation(this.getMaster(), tableName, regions, F1, F2);
    }

    @Test(timeout=60000L)
    public void testCreateWithoutColumnFamily() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)MasterProcedureTestingUtility.createHTD(tableName, new String[0]));
        builder.setValue("hbase.table.sanity.checks", Boolean.FALSE.toString());
        TableDescriptor htd = builder.build();
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])null);
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        Procedure result = procExec.getResult(procId);
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        Throwable cause = ProcedureTestingUtility.getExceptionCause((Procedure)result);
        Assert.assertTrue((String)("expected DoNotRetryIOException, got " + cause), (boolean)(cause instanceof DoNotRetryIOException));
    }

    @Test(timeout=60000L, expected=TableExistsException.class)
    public void testCreateExisting() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f");
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])null);
        long procId1 = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        ProcedurePrepareLatch.CompatibilityLatch latch2 = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId2 = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions, (ProcedurePrepareLatch)latch2));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId1));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        latch2.await();
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = null;
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, F1, F2);
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        MasterProcedureTestingUtility.validateTableCreation(this.getMaster(), tableName, regions, F1, F2);
    }

    @Test(timeout=90000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testRollbackAndDoubleExecution(TableDescriptorBuilder.newBuilder((TableDescriptor)MasterProcedureTestingUtility.createHTD(tableName, F1, F2)));
    }

    @Test(timeout=90000L)
    public void testRollbackAndDoubleExecutionOnMobTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, F1, F2);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)htd.getColumnFamily(Bytes.toBytes((String)F1))).setMobEnabled(true).build());
        this.testRollbackAndDoubleExecution(builder);
    }

    private void testRollbackAndDoubleExecution(TableDescriptorBuilder builder) throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        builder.setRegionReplication(3);
        TableDescriptor htd = builder.build();
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        int numberOfSteps = 0;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps);
        TableName tableName = htd.getTableName();
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
        this.resetProcExecutorTestingKillFlag();
        this.testSimpleCreate(tableName, splitKeys);
    }

    @Test
    public void testMRegions() throws Exception {
        byte[][] splitKeys = new byte[500][];
        for (int i = 0; i < splitKeys.length; ++i) {
            splitKeys[i] = Bytes.toBytes((String)String.format("%08d", i));
        }
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(TableName.valueOf((String)"TestMRegions"), F1, F2);
        UTIL.getAdmin().createTableAsync(htd, (byte[][])splitKeys).get(10L, TimeUnit.HOURS);
        LOG.info((Object)"TABLE CREATED");
    }
}

