/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ModifyNamespaceProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestModifyNamespaceProcedure {
    private static final Log LOG = LogFactory.getLog(TestModifyNamespaceProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestModifyNamespaceProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testModifyNamespace() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testModifyNamespace").build();
        String nsKey1 = "hbase.namespace.quota.maxregions";
        String nsValue1before = "1111";
        String nsValue1after = "9999";
        String nsKey2 = "hbase.namespace.quota.maxtables";
        String nsValue2 = "10";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        nsd.setConfiguration("hbase.namespace.quota.maxregions", "1111");
        this.createNamespaceForTesting(nsd);
        NamespaceDescriptor currentNsDescriptor = UTIL.getAdmin().getNamespaceDescriptor(nsd.getName());
        Assert.assertEquals((Object)currentNsDescriptor.getConfigurationValue("hbase.namespace.quota.maxregions"), (Object)"1111");
        Assert.assertNull((Object)currentNsDescriptor.getConfigurationValue("hbase.namespace.quota.maxtables"));
        nsd.setConfiguration("hbase.namespace.quota.maxregions", "9999");
        nsd.setConfiguration("hbase.namespace.quota.maxtables", "10");
        long procId1 = procExec.submitProcedure((Procedure)new ModifyNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        currentNsDescriptor = UTIL.getAdmin().getNamespaceDescriptor(nsd.getName());
        Assert.assertEquals((Object)nsd.getConfigurationValue("hbase.namespace.quota.maxregions"), (Object)"9999");
        Assert.assertEquals((Object)currentNsDescriptor.getConfigurationValue("hbase.namespace.quota.maxtables"), (Object)"10");
    }

    @Test(timeout=60000L)
    public void testModifyNonExistNamespace() throws Exception {
        String namespaceName = "testModifyNonExistNamespace";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        try {
            NamespaceDescriptor nsDescriptor = UTIL.getAdmin().getNamespaceDescriptor("testModifyNonExistNamespace");
            Assert.assertNull((Object)nsDescriptor);
        }
        catch (NamespaceNotFoundException nsnfe) {
            LOG.debug((Object)"The namespace testModifyNonExistNamespace does not exist.  This is expected.");
        }
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testModifyNonExistNamespace").build();
        long procId = procExec.submitProcedure((Procedure)new ModifyNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("modify namespace failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof NamespaceNotFoundException));
    }

    @Test(timeout=60000L)
    public void testModifyNamespaceWithInvalidRegionCount() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testModifyNamespaceWithInvalidRegionCount").build();
        String nsKey = "hbase.namespace.quota.maxregions";
        String nsValue = "-1";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting(nsd);
        nsd.setConfiguration("hbase.namespace.quota.maxregions", "-1");
        long procId = procExec.submitProcedure((Procedure)new ModifyNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Modify namespace failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof ConstraintException));
    }

    @Test(timeout=60000L)
    public void testModifyNamespaceWithInvalidTableCount() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testModifyNamespaceWithInvalidTableCount").build();
        String nsKey = "hbase.namespace.quota.maxtables";
        String nsValue = "-1";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting(nsd);
        nsd.setConfiguration("hbase.namespace.quota.maxtables", "-1");
        long procId = procExec.submitProcedure((Procedure)new ModifyNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Modify namespace failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof ConstraintException));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testRecoveryAndDoubleExecution").build();
        String nsKey = "foo";
        String nsValue = "bar";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting(nsd);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        nsd.setConfiguration("foo", "bar");
        long procId = procExec.submitProcedure((Procedure)new ModifyNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        NamespaceDescriptor currentNsDescriptor = UTIL.getAdmin().getNamespaceDescriptor(nsd.getName());
        Assert.assertEquals((Object)currentNsDescriptor.getConfigurationValue("foo"), (Object)"bar");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)"testRollbackAndDoubleExecution").build();
        String nsKey = "foo";
        String nsValue = "bar";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting(nsd);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        nsd.setConfiguration("foo", "bar");
        long procId = procExec.submitProcedure((Procedure)new ModifyNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        int numberOfSteps = 0;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps);
        NamespaceDescriptor currentNsDescriptor = UTIL.getAdmin().getNamespaceDescriptor(nsd.getName());
        Assert.assertNull((Object)currentNsDescriptor.getConfigurationValue("foo"));
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void createNamespaceForTesting(NamespaceDescriptor nsDescriptor) throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsDescriptor));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }
}

