/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.RestoreSnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRestoreSnapshotProcedure
extends TestTableDDLProcedureBase {
    private static final Log LOG = LogFactory.getLog(TestRestoreSnapshotProcedure.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    protected final TableName snapshotTableName = TableName.valueOf((String)"testRestoreSnapshot");
    protected final byte[] CF1 = Bytes.toBytes((String)"cf1");
    protected final byte[] CF2 = Bytes.toBytes((String)"cf2");
    protected final byte[] CF3 = Bytes.toBytes((String)"cf3");
    protected final byte[] CF4 = Bytes.toBytes((String)"cf4");
    protected final int rowCountCF1 = 10;
    protected final int rowCountCF2 = 40;
    protected final int rowCountCF3 = 40;
    protected final int rowCountCF4 = 40;
    protected final int rowCountCF1addition = 10;
    private SnapshotProtos.SnapshotDescription snapshot = null;
    private HTableDescriptor snapshotHTD = null;
    @Rule
    public TestName name = new TestName();

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.setupSnapshotAndUpdateTable();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    private int getNumReplicas() {
        return 1;
    }

    private void setupSnapshotAndUpdateTable() throws Exception {
        long tid = System.currentTimeMillis();
        byte[] snapshotName = Bytes.toBytes((String)("snapshot-" + tid));
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.createTable(UTIL, this.snapshotTableName, this.getNumReplicas(), (byte[][])new byte[][]{this.CF1, this.CF2});
        SnapshotTestingUtils.loadData(UTIL, this.snapshotTableName, 10, (byte[][])new byte[][]{this.CF1});
        SnapshotTestingUtils.loadData(UTIL, this.snapshotTableName, 40, (byte[][])new byte[][]{this.CF2});
        SnapshotTestingUtils.verifyRowCount(UTIL, this.snapshotTableName, 50L);
        this.snapshotHTD = admin.getTableDescriptor(this.snapshotTableName);
        admin.disableTable(this.snapshotTableName);
        admin.snapshot(snapshotName, this.snapshotTableName);
        List snapshotList = admin.listSnapshots();
        this.snapshot = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)((SnapshotDescription)snapshotList.get(0)));
        HColumnDescriptor columnFamilyDescriptor3 = new HColumnDescriptor(this.CF3);
        HColumnDescriptor columnFamilyDescriptor4 = new HColumnDescriptor(this.CF4);
        admin.addColumnFamily(this.snapshotTableName, (ColumnFamilyDescriptor)columnFamilyDescriptor3);
        admin.addColumnFamily(this.snapshotTableName, (ColumnFamilyDescriptor)columnFamilyDescriptor4);
        admin.deleteColumnFamily(this.snapshotTableName, this.CF2);
        admin.enableTable(this.snapshotTableName);
        SnapshotTestingUtils.loadData(UTIL, this.snapshotTableName, 40, (byte[][])new byte[][]{this.CF3});
        SnapshotTestingUtils.loadData(UTIL, this.snapshotTableName, 40, (byte[][])new byte[][]{this.CF4});
        SnapshotTestingUtils.loadData(UTIL, this.snapshotTableName, 10, (byte[][])new byte[][]{this.CF1});
        HTableDescriptor currentHTD = admin.getTableDescriptor(this.snapshotTableName);
        Assert.assertTrue((boolean)currentHTD.hasFamily(this.CF1));
        Assert.assertFalse((boolean)currentHTD.hasFamily(this.CF2));
        Assert.assertTrue((boolean)currentHTD.hasFamily(this.CF3));
        Assert.assertTrue((boolean)currentHTD.hasFamily(this.CF4));
        Assert.assertNotEquals((long)currentHTD.getFamiliesKeys().size(), (long)this.snapshotHTD.getFamiliesKeys().size());
        SnapshotTestingUtils.verifyRowCount(UTIL, this.snapshotTableName, 100L);
        admin.disableTable(this.snapshotTableName);
    }

    private static HTableDescriptor createHTableDescriptor(TableName tableName, byte[] ... family) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < family.length; ++i) {
            htd.addFamily(new HColumnDescriptor(family[i]));
        }
        return htd;
    }

    @Test(timeout=600000L)
    public void testRestoreSnapshot() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new RestoreSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)this.snapshotHTD, this.snapshot));
        ProcedureTestingUtility.assertProcNotFailed((Procedure)procExec.getResult(procId));
        this.validateSnapshotRestore();
    }

    @Test(timeout=60000L)
    public void testRestoreSnapshotToDifferentTable() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TableName restoredTableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor newHTD = TestRestoreSnapshotProcedure.createHTableDescriptor(restoredTableName, this.CF1, this.CF2);
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new RestoreSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)newHTD, this.snapshot));
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Restore snapshot failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRestoreSnapshotToEnabledTable() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        try {
            UTIL.getAdmin().enableTable(this.snapshotTableName);
            long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new RestoreSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)this.snapshotHTD, this.snapshot));
            Procedure result = procExec.getResult(procId);
            Assert.assertTrue((boolean)result.isFailed());
            LOG.debug((Object)("Restore snapshot failed with exception: " + result.getException()));
            Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotDisabledException));
        }
        finally {
            UTIL.getAdmin().disableTable(this.snapshotTableName);
        }
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new RestoreSnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), (TableDescriptor)this.snapshotHTD, this.snapshot));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        this.resetProcExecutorTestingKillFlag();
        this.validateSnapshotRestore();
    }

    private void validateSnapshotRestore() throws IOException {
        try {
            UTIL.getAdmin().enableTable(this.snapshotTableName);
            HTableDescriptor currentHTD = UTIL.getAdmin().getTableDescriptor(this.snapshotTableName);
            Assert.assertTrue((boolean)currentHTD.hasFamily(this.CF1));
            Assert.assertTrue((boolean)currentHTD.hasFamily(this.CF2));
            Assert.assertFalse((boolean)currentHTD.hasFamily(this.CF3));
            Assert.assertFalse((boolean)currentHTD.hasFamily(this.CF4));
            Assert.assertEquals((long)currentHTD.getFamiliesKeys().size(), (long)this.snapshotHTD.getFamiliesKeys().size());
            SnapshotTestingUtils.verifyRowCount(UTIL, this.snapshotTableName, 50L);
        }
        finally {
            UTIL.getAdmin().disableTable(this.snapshotTableName);
        }
    }
}

