/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class TestTableDDLProcedureBase {
    private static final Log LOG = LogFactory.getLog(TestTableDDLProcedureBase.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestTableDDLProcedureBase.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        this.resetProcExecutorTestingKillFlag();
    }

    @After
    public void tearDown() throws Exception {
        this.resetProcExecutorTestingKillFlag();
        for (HTableDescriptor htd : UTIL.getAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    protected void resetProcExecutorTestingKillFlag() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    protected ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return this.getMaster().getMasterProcedureExecutor();
    }

    protected HMaster getMaster() {
        return UTIL.getHBaseCluster().getMaster();
    }
}

