/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTruncateTableProcedure
extends TestTableDDLProcedureBase {
    private static final Log LOG = LogFactory.getLog(TestTruncateTableProcedure.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public TestName name = new TestName();

    @Test(timeout=60000L)
    public void testTruncateNotExistentTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Truncate failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotFoundException));
    }

    @Test(timeout=60000L)
    public void testTruncateNotDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Truncate failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotDisabledException));
    }

    @Test(timeout=60000L)
    public void testSimpleTruncatePreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testSimpleTruncate(tableName, true);
    }

    @Test(timeout=60000L)
    public void testSimpleTruncateNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testSimpleTruncate(tableName, false);
    }

    private void testSimpleTruncate(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getAdmin().getTableRegions(tableName).toArray(new RegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testRecoveryAndDoubleExecution(tableName, true);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionNoPreserveSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testRecoveryAndDoubleExecution(tableName, false);
    }

    private void testRecoveryAndDoubleExecution(TableName tableName, boolean preserveSplits) throws Exception {
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getAdmin().getTableRegions(tableName).toArray(new RegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }
}

