/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestDefaultMobStoreFlusher {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qf1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qf2");
    private static final byte[] value1 = Bytes.toBytes((String)"value1");
    private static final byte[] value2 = Bytes.toBytes((String)"value2");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFlushNonMobFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        this.testFlushFile(desc);
    }

    @Test
    public void testFlushMobFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        this.testFlushFile(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFlushFile(HTableDescriptor htd) throws Exception {
        try (Table table = null;){
            table = TEST_UTIL.createTable((TableDescriptor)htd, (byte[][])null);
            Put put0 = new Put(row1);
            put0.addColumn(family, qf1, 1L, value1);
            table.put(put0);
            Put put1 = new Put(row2);
            put1.addColumn(family, qf2, 1L, value2);
            table.put(put1);
            TEST_UTIL.flush(htd.getTableName());
            Scan scan = new Scan();
            scan.addColumn(family, qf1);
            scan.setMaxVersions(4);
            ResultScanner scanner = table.getScanner(scan);
            int size = 0;
            for (Result result : scanner) {
                ++size;
                List cells = result.getColumnCells(family, qf1);
                Assert.assertEquals((long)1L, (long)cells.size());
                Assert.assertArrayEquals((byte[])value1, (byte[])CellUtil.cloneValue((Cell)((Cell)cells.get(0))));
            }
            scanner.close();
            Assert.assertEquals((long)1L, (long)size);
        }
    }
}

