/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestReplicationProtobuf {
    @Test
    public void testGetCellScanner() throws IOException {
        ArrayList<KeyValue> a = new ArrayList<KeyValue>();
        KeyValue akv = new KeyValue(Bytes.toBytes((String)"a"), -1L);
        a.add(akv);
        a.add(new KeyValue(Bytes.toBytes((String)"aa"), -1L));
        a.add(new KeyValue(Bytes.toBytes((String)"aaa"), -1L));
        ArrayList b = new ArrayList();
        KeyValue bkv = new KeyValue(Bytes.toBytes((String)"b"), -1L);
        a.add(bkv);
        ArrayList<KeyValue> c = new ArrayList<KeyValue>();
        KeyValue ckv = new KeyValue(Bytes.toBytes((String)"c"), -1L);
        c.add(ckv);
        ArrayList all = new ArrayList();
        all.add(a);
        all.add(b);
        all.add(c);
        CellScanner scanner = ReplicationProtbufUtil.getCellScanner(all, (int)0);
        this.testAdvancetHasSameRow(scanner, akv);
        scanner.advance();
        scanner.advance();
        this.testAdvancetHasSameRow(scanner, bkv);
        this.testAdvancetHasSameRow(scanner, ckv);
        Assert.assertFalse((boolean)scanner.advance());
    }

    private void testAdvancetHasSameRow(CellScanner scanner, KeyValue kv) throws IOException {
        scanner.advance();
        Assert.assertTrue((boolean)Bytes.equals((byte[])scanner.current().getRowArray(), (int)scanner.current().getRowOffset(), (int)scanner.current().getRowLength(), (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
    }
}

