/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifierForTest;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Multimap;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestQuotaObserverChoreWithMiniCluster {
    private static final Log LOG = LogFactory.getLog(TestQuotaObserverChoreWithMiniCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private static final long DEFAULT_WAIT_MILLIS = 500L;
    @Rule
    public TestName testName = new TestName();
    private HMaster master;
    private QuotaObserverChore chore;
    private SpaceQuotaSnapshotNotifierForTest snapshotNotifier;
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.setClass("hbase.master.quota.snapshot.notifier.impl", SpaceQuotaSnapshotNotifierForTest.class, SpaceQuotaSnapshotNotifier.class);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        if (this.helper == null) {
            this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        }
        if (!conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            this.helper.waitForQuotaTable(conn);
        } else {
            this.helper.removeAllQuotas(conn);
            Assert.assertEquals((long)0L, (long)this.helper.listNumDefinedQuotas(conn));
        }
        this.master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        this.snapshotNotifier = (SpaceQuotaSnapshotNotifierForTest)this.master.getSpaceQuotaSnapshotNotifier();
        Assert.assertNotNull((Object)this.snapshotNotifier);
        this.snapshotNotifier.clearSnapshots();
        this.chore = this.master.getQuotaObserverChore();
    }

    @Test
    public void testTableViolatesQuota() throws Exception {
        SpaceQuotaSnapshot snapshot;
        Map.Entry entry;
        TableName tn = this.helper.createTableWithRegions(10);
        long sizeLimit = 0x200000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x200000L, (SpaceViolationPolicy)violationPolicy);
        TEST_UTIL.getAdmin().setQuota(settings);
        this.helper.writeData(tn, 0x300000L);
        Map<TableName, SpaceQuotaSnapshot> quotaSnapshots = this.snapshotNotifier.copySnapshots();
        boolean foundSnapshot = false;
        while (!foundSnapshot) {
            if (quotaSnapshots.isEmpty()) {
                LOG.info((Object)("Found no violated quotas, sleeping and retrying. Current reports: " + this.master.getMasterQuotaManager().snapshotRegionSizes()));
                this.sleepWithInterrupt(500L);
                quotaSnapshots = this.snapshotNotifier.copySnapshots();
                continue;
            }
            entry = (Map.Entry)Iterables.getOnlyElement(quotaSnapshots.entrySet());
            Assert.assertEquals((Object)tn, entry.getKey());
            snapshot = (SpaceQuotaSnapshot)entry.getValue();
            if (!snapshot.getQuotaStatus().isInViolation()) {
                LOG.info((Object)("Found a snapshot, but it was not yet in violation. " + snapshot));
                this.sleepWithInterrupt(500L);
                quotaSnapshots = this.snapshotNotifier.copySnapshots();
                continue;
            }
            foundSnapshot = true;
        }
        entry = (Map.Entry)Iterables.getOnlyElement(quotaSnapshots.entrySet());
        Assert.assertEquals((Object)tn, entry.getKey());
        snapshot = (SpaceQuotaSnapshot)entry.getValue();
        Assert.assertEquals((String)("Snapshot was " + snapshot), (Object)violationPolicy, (Object)snapshot.getQuotaStatus().getPolicy());
        Assert.assertEquals((long)0x200000L, (long)snapshot.getLimit());
        Assert.assertTrue((String)("The usage should be greater than the limit, but were " + snapshot.getUsage() + " and " + snapshot.getLimit() + ", respectively"), (snapshot.getUsage() > snapshot.getLimit() ? 1 : 0) != 0);
    }

    @Test
    public void testNamespaceViolatesQuota() throws Exception {
        int i;
        String namespace = this.testName.getMethodName();
        Admin admin = TEST_UTIL.getAdmin();
        try {
            admin.getNamespaceDescriptor(namespace);
        }
        catch (NamespaceNotFoundException e) {
            NamespaceDescriptor desc = NamespaceDescriptor.create((String)namespace).build();
            admin.createNamespace(desc);
        }
        TableName tn1 = this.helper.createTableWithRegions(namespace, 5);
        TableName tn2 = this.helper.createTableWithRegions(namespace, 5);
        TableName tn3 = this.helper.createTableWithRegions(namespace, 5);
        long sizeLimit = 0x500000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.DISABLE;
        QuotaSettings settings = QuotaSettingsFactory.limitNamespaceSpace((String)namespace, (long)0x500000L, (SpaceViolationPolicy)violationPolicy);
        admin.setQuota(settings);
        this.helper.writeData(tn1, 0x200000L);
        admin.flush(tn1);
        Map<TableName, SpaceQuotaSnapshot> snapshots = this.snapshotNotifier.copySnapshots();
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)"Should not see any quota violations after writing 2MB of data", (long)0L, (long)this.numSnapshotsInViolation(snapshots));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Interrupted while sleeping.", (Throwable)e);
            }
            snapshots = this.snapshotNotifier.copySnapshots();
        }
        this.helper.writeData(tn2, 0x200000L);
        admin.flush(tn2);
        snapshots = this.snapshotNotifier.copySnapshots();
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((String)"Should not see any quota violations after writing 4MB of data", (long)0L, (long)this.numSnapshotsInViolation(snapshots));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Interrupted while sleeping.", (Throwable)e);
            }
            snapshots = this.snapshotNotifier.copySnapshots();
        }
        this.helper.writeData(tn3, 0x200000L);
        admin.flush(tn3);
        snapshots = this.snapshotNotifier.copySnapshots();
        while (this.numSnapshotsInViolation(snapshots) < 3) {
            LOG.debug((Object)("Saw fewer violations than desired (expected 3): " + snapshots + ". Current reports: " + this.master.getMasterQuotaManager().snapshotRegionSizes()));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Interrupted while sleeping.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            snapshots = this.snapshotNotifier.copySnapshots();
        }
        SpaceQuotaSnapshot snapshot1 = snapshots.remove(tn1);
        Assert.assertNotNull((String)"tn1 should be in violation", (Object)snapshot1);
        Assert.assertEquals((Object)violationPolicy, (Object)snapshot1.getQuotaStatus().getPolicy());
        SpaceQuotaSnapshot snapshot2 = snapshots.remove(tn2);
        Assert.assertNotNull((String)"tn2 should be in violation", (Object)snapshot2);
        Assert.assertEquals((Object)violationPolicy, (Object)snapshot2.getQuotaStatus().getPolicy());
        SpaceQuotaSnapshot snapshot3 = snapshots.remove(tn3);
        Assert.assertNotNull((String)"tn3 should be in violation", (Object)snapshot3);
        Assert.assertEquals((Object)violationPolicy, (Object)snapshot3.getQuotaStatus().getPolicy());
        Assert.assertTrue((String)("Unexpected additional quota violations: " + snapshots), (boolean)snapshots.isEmpty());
    }

    @Test
    public void testTableQuotaOverridesNamespaceQuota() throws Exception {
        SpaceQuotaSnapshot actualTableSnapshot;
        String namespace = this.testName.getMethodName();
        Admin admin = TEST_UTIL.getAdmin();
        try {
            admin.getNamespaceDescriptor(namespace);
        }
        catch (NamespaceNotFoundException e) {
            NamespaceDescriptor desc = NamespaceDescriptor.create((String)namespace).build();
            admin.createNamespace(desc);
        }
        TableName tn1 = this.helper.createTableWithRegions(namespace, 5);
        TableName tn2 = this.helper.createTableWithRegions(namespace, 5);
        long namespaceSizeLimit = 0x300000L;
        SpaceViolationPolicy namespaceViolationPolicy = SpaceViolationPolicy.DISABLE;
        QuotaSettings namespaceSettings = QuotaSettingsFactory.limitNamespaceSpace((String)namespace, (long)0x300000L, (SpaceViolationPolicy)namespaceViolationPolicy);
        admin.setQuota(namespaceSettings);
        this.helper.writeData(tn1, 0x200000L);
        admin.flush(tn1);
        Map<TableName, SpaceQuotaSnapshot> snapshots = this.snapshotNotifier.copySnapshots();
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("Should not see any quota violations after writing 2MB of data: " + snapshots), (long)0L, (long)this.numSnapshotsInViolation(snapshots));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Interrupted while sleeping.", (Throwable)e);
            }
            snapshots = this.snapshotNotifier.copySnapshots();
        }
        this.helper.writeData(tn2, 0x200000L);
        admin.flush(tn2);
        snapshots = this.snapshotNotifier.copySnapshots();
        while (this.numSnapshotsInViolation(snapshots) < 2) {
            LOG.debug((Object)("Saw fewer violations than desired (expected 2): " + snapshots + ". Current reports: " + this.master.getMasterQuotaManager().snapshotRegionSizes()));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Interrupted while sleeping.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            snapshots = this.snapshotNotifier.copySnapshots();
        }
        SpaceQuotaSnapshot actualPolicyTN1 = snapshots.get(tn1);
        Assert.assertNotNull((String)"Expected to see violation policy for tn1", (Object)actualPolicyTN1);
        Assert.assertEquals((Object)namespaceViolationPolicy, (Object)actualPolicyTN1.getQuotaStatus().getPolicy());
        SpaceQuotaSnapshot actualPolicyTN2 = snapshots.get(tn2);
        Assert.assertNotNull((String)"Expected to see violation policy for tn2", (Object)actualPolicyTN2);
        Assert.assertEquals((Object)namespaceViolationPolicy, (Object)actualPolicyTN2.getQuotaStatus().getPolicy());
        long tableSizeLimit = 0x100000L;
        SpaceViolationPolicy tableViolationPolicy = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings tableSettings = QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x100000L, (SpaceViolationPolicy)tableViolationPolicy);
        admin.setQuota(tableSettings);
        while (true) {
            snapshots = this.snapshotNotifier.copySnapshots();
            actualTableSnapshot = snapshots.get(tn1);
            Assert.assertNotNull((String)"Violation policy should never be null", (Object)actualTableSnapshot);
            if (tableViolationPolicy == actualTableSnapshot.getQuotaStatus().getPolicy()) break;
            LOG.debug((Object)"Saw unexpected table violation policy, waiting and re-checking.");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Interrupted while sleeping");
                Thread.currentThread().interrupt();
            }
        }
        Assert.assertEquals((Object)tableViolationPolicy, (Object)actualTableSnapshot.getQuotaStatus().getPolicy());
        actualPolicyTN2 = snapshots.get(tn2);
        Assert.assertNotNull((String)"Expected to see violation policy for tn2", (Object)actualPolicyTN2);
        Assert.assertEquals((Object)namespaceViolationPolicy, (Object)actualPolicyTN2.getQuotaStatus().getPolicy());
    }

    @Test
    public void testGetAllTablesWithQuotas() throws Exception {
        Multimap<TableName, QuotaSettings> quotas = this.helper.createTablesWithSpaceQuotas();
        HashSet<TableName> tablesWithQuotas = new HashSet<TableName>();
        HashSet<TableName> namespaceTablesWithQuotas = new HashSet<TableName>();
        this.helper.partitionTablesByQuotaTarget(quotas, tablesWithQuotas, namespaceTablesWithQuotas);
        QuotaObserverChore.TablesWithQuotas tables = this.chore.fetchAllTablesWithQuotasDefined();
        Assert.assertEquals((String)("Found tables: " + tables), tablesWithQuotas, (Object)tables.getTableQuotaTables());
        Assert.assertEquals((String)("Found tables: " + tables), namespaceTablesWithQuotas, (Object)tables.getNamespaceQuotaTables());
    }

    @Test
    public void testRpcQuotaTablesAreFiltered() throws Exception {
        Multimap<TableName, QuotaSettings> quotas = this.helper.createTablesWithSpaceQuotas();
        HashSet<TableName> tablesWithQuotas = new HashSet<TableName>();
        HashSet<TableName> namespaceTablesWithQuotas = new HashSet<TableName>();
        this.helper.partitionTablesByQuotaTarget(quotas, tablesWithQuotas, namespaceTablesWithQuotas);
        TableName rpcQuotaTable = this.helper.createTable();
        TEST_UTIL.getAdmin().setQuota(QuotaSettingsFactory.throttleTable((TableName)rpcQuotaTable, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        QuotaObserverChore.TablesWithQuotas tables = this.chore.fetchAllTablesWithQuotasDefined();
        Assert.assertEquals((String)("Found tables: " + tables), tablesWithQuotas, (Object)tables.getTableQuotaTables());
        Assert.assertEquals((String)("Found tables: " + tables), namespaceTablesWithQuotas, (Object)tables.getNamespaceQuotaTables());
    }

    @Test
    public void testFilterRegions() throws Exception {
        final HashMap<TableName, Integer> mockReportedRegions = new HashMap<TableName, Integer>();
        QuotaObserverChore.TablesWithQuotas tables = new QuotaObserverChore.TablesWithQuotas(TEST_UTIL.getConnection(), TEST_UTIL.getConfiguration()){

            int getNumReportedRegions(TableName table, QuotaSnapshotStore<TableName> tableStore) {
                Integer i = (Integer)mockReportedRegions.get(table);
                if (i == null) {
                    return 0;
                }
                return i;
            }
        };
        TableName tn1 = this.helper.createTableWithRegions(20);
        TableName tn2 = this.helper.createTableWithRegions(20);
        TableName tn3 = this.helper.createTableWithRegions(20);
        tables.addTableQuotaTable(tn1);
        tables.addTableQuotaTable(tn2);
        tables.addTableQuotaTable(tn3);
        mockReportedRegions.put(tn1, 10);
        mockReportedRegions.put(tn2, 19);
        mockReportedRegions.put(tn3, 20);
        tables.filterInsufficientlyReportedTables(null);
        Assert.assertEquals(new HashSet<TableName>(Arrays.asList(tn2, tn3)), (Object)tables.getTableQuotaTables());
    }

    @Test
    public void testFetchSpaceQuota() throws Exception {
        Multimap<TableName, QuotaSettings> tables = this.helper.createTablesWithSpaceQuotas();
        this.chore.initializeSnapshotStores(Collections.emptyMap());
        for (Map.Entry entry : tables.entries()) {
            TableName table = (TableName)entry.getKey();
            QuotaSettings qs = (QuotaSettings)entry.getValue();
            Assert.assertTrue((String)("QuotaSettings was an instance of " + qs.getClass()), (boolean)(qs instanceof SpaceLimitSettings));
            QuotaProtos.SpaceQuota spaceQuota = null;
            if (qs.getTableName() != null) {
                spaceQuota = this.chore.getTableSnapshotStore().getSpaceQuota((Object)table);
                Assert.assertNotNull((String)("Could not find table space quota for " + table), (Object)spaceQuota);
            } else if (qs.getNamespace() != null) {
                spaceQuota = this.chore.getNamespaceSnapshotStore().getSpaceQuota((Object)table.getNamespaceAsString());
                Assert.assertNotNull((String)("Could not find namespace space quota for " + table.getNamespaceAsString()), (Object)spaceQuota);
            } else {
                Assert.fail((String)"Expected table or namespace space quota");
            }
            SpaceLimitSettings sls = (SpaceLimitSettings)qs;
            Assert.assertEquals((Object)sls.getProto().getQuota(), (Object)spaceQuota);
        }
        TableName tableWithoutQuota = this.helper.createTable();
        Assert.assertNull((Object)this.chore.getTableSnapshotStore().getSpaceQuota((Object)tableWithoutQuota));
    }

    private int numSnapshotsInViolation(Map<TableName, SpaceQuotaSnapshot> snapshots) {
        int sum = 0;
        for (SpaceQuotaSnapshot snapshot : snapshots.values()) {
            if (!snapshot.getQuotaStatus().isInViolation()) continue;
            ++sum;
        }
        return sum;
    }

    private void sleepWithInterrupt(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Interrupted while sleeping");
            Thread.currentThread().interrupt();
        }
    }
}

