/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestQuotaThrottle {
    private static final Log LOG = LogFactory.getLog(TestQuotaThrottle.class);
    private static final int REFRESH_TIME = 1800000;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final TableName[] TABLE_NAMES = new TableName[]{TableName.valueOf((String)"TestQuotaAdmin0"), TableName.valueOf((String)"TestQuotaAdmin1"), TableName.valueOf((String)"TestQuotaAdmin2")};
    private static ManualEnvironmentEdge envEdge;
    private static Table[] tables;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 1800000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        QuotaCache.TEST_FORCE_REFRESH = true;
        tables = new Table[TABLE_NAMES.length];
        for (int i = 0; i < TABLE_NAMES.length; ++i) {
            TestQuotaThrottle.tables[i] = TEST_UTIL.createTable(TABLE_NAMES[i], FAMILY);
        }
        envEdge = new ManualEnvironmentEdge();
        envEdge.setValue(EnvironmentEdgeManager.currentTime());
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)envEdge);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        EnvironmentEdgeManager.reset();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == null) continue;
            tables[i].close();
            TEST_UTIL.deleteTable(TABLE_NAMES[i]);
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        for (JVMClusterUtil.RegionServerThread rst : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rst.getRegionServer().getRegionServerRpcQuotaManager();
            QuotaCache quotaCache = quotaManager.getQuotaCache();
            quotaCache.getNamespaceQuotaCache().clear();
            quotaCache.getTableQuotaCache().clear();
            quotaCache.getUserQuotaCache().clear();
        }
    }

    @Test(timeout=60000L)
    public void testUserGlobalThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables));
        this.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.triggerUserCacheRefresh(true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables));
    }

    @Test(timeout=60000L)
    public void testUserGlobalReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)6L, (long)this.doGets(100, tables));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES);
        Assert.assertEquals((long)6L, (long)this.doGets(100, tables));
        Assert.assertEquals((long)6L, (long)this.doPuts(60, tables));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.triggerUserCacheRefresh(true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables));
    }

    @Test(timeout=60000L)
    public void testUserTableThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doPuts(30, tables[1]));
        this.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[0]));
        this.triggerUserCacheRefresh(true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables));
    }

    @Test(timeout=60000L)
    public void testUserTableReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables[0]));
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables[1]));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables[1]));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)6L, (long)this.doGets(60, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doPuts(30, tables[1]));
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[0]));
        this.triggerUserCacheRefresh(true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables));
    }

    @Test(timeout=60000L)
    public void testUserNamespaceThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)"default", (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        this.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (String)"default"));
        this.triggerUserCacheRefresh(true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables));
    }

    @Test(timeout=60000L)
    public void testUserNamespaceReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)"default", (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doGets(60, tables[0]));
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables[0]));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)"default", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doGets(60, tables[0]));
        Assert.assertEquals((long)6L, (long)this.doPuts(60, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (String)"default"));
        this.triggerUserCacheRefresh(true, TABLE_NAMES);
        Assert.assertEquals((long)60L, (long)this.doPuts(60, tables));
        Assert.assertEquals((long)60L, (long)this.doGets(60, tables));
    }

    @Test(timeout=60000L)
    public void testTableGlobalThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerTableCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doPuts(30, tables[1]));
        this.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        this.triggerTableCacheRefresh(true, TABLE_NAMES[0]);
        Assert.assertEquals((long)80L, (long)this.doGets(80, tables[0], tables[1]));
    }

    @Test(timeout=60000L)
    public void testTableGlobalReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerTableCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doGets(100, tables[0]));
        Assert.assertEquals((long)100L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doPuts(30, tables[1]));
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[1]));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerTableCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doGets(100, tables[0]));
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doPuts(30, tables[1]));
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        this.triggerTableCacheRefresh(true, TABLE_NAMES[0]);
        Assert.assertEquals((long)80L, (long)this.doGets(80, tables[0], tables[1]));
    }

    @Test(timeout=60000L)
    public void testNamespaceGlobalThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerNamespaceCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        this.waitMinuteQuota();
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        this.triggerNamespaceCacheRefresh(true, TABLE_NAMES[0]);
        Assert.assertEquals((long)40L, (long)this.doPuts(40, tables[0]));
    }

    @Test(timeout=60000L)
    public void testNamespaceGlobalReadAndWriteThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerNamespaceCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)100L, (long)this.doGets(100, tables[0]));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerNamespaceCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)6L, (long)this.doGets(100, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        this.triggerNamespaceCacheRefresh(true, TABLE_NAMES[0]);
        Assert.assertEquals((long)40L, (long)this.doPuts(40, tables[0]));
    }

    @Test(timeout=60000L)
    public void testUserAndTableThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[0]);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)12L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[1], TABLE_NAMES[2]);
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[1], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)8L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerTableCacheRefresh(false, TABLE_NAMES[1]);
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)3L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerTableCacheRefresh(false, TABLE_NAMES[0]);
        Assert.assertEquals((long)12L, (long)this.doGets(100, tables[2]));
        this.waitMinuteQuota();
        Assert.assertEquals((long)8L, (long)this.doGets(100, tables[1]));
        this.waitMinuteQuota();
        Assert.assertEquals((long)3L, (long)this.doPuts(100, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.triggerUserCacheRefresh(true, TABLE_NAMES[0], TABLE_NAMES[1]);
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[1]));
        this.triggerTableCacheRefresh(true, TABLE_NAMES[1]);
        this.waitMinuteQuota();
        Assert.assertEquals((long)40L, (long)this.doGets(40, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        this.triggerTableCacheRefresh(true, TABLE_NAMES[0]);
        this.waitMinuteQuota();
        Assert.assertEquals((long)40L, (long)this.doGets(40, tables[0]));
    }

    @Test(timeout=60000L)
    public void testUserGlobalBypassThrottle() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerTableCacheRefresh(false, TABLE_NAMES[0]);
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)13L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerNamespaceCacheRefresh(false, TABLE_NAMES[1]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)7L, (long)this.doGets(100, tables[1]));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[2], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        this.triggerUserCacheRefresh(false, TABLE_NAMES[2]);
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[1]));
        this.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (TableName)TABLE_NAMES[2]));
        this.triggerUserCacheRefresh(true, TABLE_NAMES[2]);
        Assert.assertEquals((long)6L, (long)this.doPuts(100, tables[0]));
        Assert.assertEquals((long)7L, (long)this.doGets(100, tables[1]));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        this.waitMinuteQuota();
        this.triggerTableCacheRefresh(true, TABLE_NAMES[0]);
        this.triggerNamespaceCacheRefresh(true, TABLE_NAMES[1]);
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[0]));
        Assert.assertEquals((long)30L, (long)this.doGets(30, tables[1]));
    }

    private int doPuts(int maxOps, Table ... tables) throws Exception {
        int count;
        try {
            for (count = 0; count < maxOps; count += tables.length) {
                Put put = new Put(Bytes.toBytes((String)("row-" + count)));
                put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("data-" + count)));
                for (Table table : tables) {
                    table.put(put);
                }
            }
        }
        catch (ThrottlingException e) {
            LOG.error((Object)("put failed after nRetries=" + count), (Throwable)e);
        }
        return count;
    }

    private long doGets(int maxOps, Table ... tables) throws Exception {
        int count;
        try {
            for (count = 0; count < maxOps; count += tables.length) {
                Get get = new Get(Bytes.toBytes((String)("row-" + count)));
                for (Table table : tables) {
                    table.get(get);
                }
            }
        }
        catch (ThrottlingException e) {
            LOG.error((Object)("get failed after nRetries=" + count), (Throwable)e);
        }
        return count;
    }

    private void triggerUserCacheRefresh(boolean bypass, TableName ... tables) throws Exception {
        this.triggerCacheRefresh(bypass, true, false, false, tables);
    }

    private void triggerTableCacheRefresh(boolean bypass, TableName ... tables) throws Exception {
        this.triggerCacheRefresh(bypass, false, true, false, tables);
    }

    private void triggerNamespaceCacheRefresh(boolean bypass, TableName ... tables) throws Exception {
        this.triggerCacheRefresh(bypass, false, false, true, tables);
    }

    private void triggerCacheRefresh(boolean bypass, boolean userLimiter, boolean tableLimiter, boolean nsLimiter, TableName ... tables) throws Exception {
        envEdge.incValue(3600000L);
        for (JVMClusterUtil.RegionServerThread rst : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rst.getRegionServer().getRegionServerRpcQuotaManager();
            QuotaCache quotaCache = quotaManager.getQuotaCache();
            quotaCache.triggerCacheRefresh();
            Thread.sleep(250L);
            for (TableName table : tables) {
                quotaCache.getTableLimiter(table);
            }
            boolean isUpdated = false;
            block2: while (!isUpdated) {
                quotaCache.triggerCacheRefresh();
                isUpdated = true;
                for (TableName table : tables) {
                    boolean isBypass = true;
                    if (userLimiter) {
                        isBypass &= quotaCache.getUserLimiter(User.getCurrent().getUGI(), table).isBypass();
                    }
                    if (tableLimiter) {
                        isBypass &= quotaCache.getTableLimiter(table).isBypass();
                    }
                    if (nsLimiter) {
                        isBypass &= quotaCache.getNamespaceLimiter(table.getNamespaceAsString()).isBypass();
                    }
                    if (isBypass == bypass) continue;
                    envEdge.incValue(100L);
                    isUpdated = false;
                    continue block2;
                }
            }
            LOG.debug((Object)"QuotaCache");
            LOG.debug((Object)quotaCache.getNamespaceQuotaCache());
            LOG.debug((Object)quotaCache.getTableQuotaCache());
            LOG.debug((Object)quotaCache.getUserQuotaCache());
        }
    }

    private void waitMinuteQuota() {
        envEdge.incValue(70000L);
    }
}

