/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Optional;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.security.User;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class StatefulStoreMockMaker {
    public Optional<CompactionContext> selectCompaction() {
        return Optional.empty();
    }

    public void cancelCompaction(Object originalContext) {
    }

    public int getPriority() {
        return 0;
    }

    public HStore createStoreMock(String name) throws Exception {
        HStore store = (HStore)Mockito.mock(HStore.class, (String)name);
        Mockito.when((Object)store.requestCompaction(Matchers.anyInt(), (CompactionLifeCycleTracker)Matchers.any(CompactionLifeCycleTracker.class), (User)Matchers.any(User.class))).then((Answer)new SelectAnswer());
        Mockito.when((Object)store.getCompactPriority()).then((Answer)new PriorityAnswer());
        ((HStore)Mockito.doAnswer((Answer)new CancelAnswer()).when((Object)store)).cancelRequestedCompaction((CompactionContext)Matchers.any(CompactionContext.class));
        return store;
    }

    private class CancelAnswer
    implements Answer<Object> {
        private CancelAnswer() {
        }

        public CompactionContext answer(InvocationOnMock invocation) throws Throwable {
            StatefulStoreMockMaker.this.cancelCompaction(invocation.getArguments()[0]);
            return null;
        }
    }

    private class PriorityAnswer
    implements Answer<Integer> {
        private PriorityAnswer() {
        }

        public Integer answer(InvocationOnMock invocation) throws Throwable {
            return StatefulStoreMockMaker.this.getPriority();
        }
    }

    private class SelectAnswer
    implements Answer<Optional<CompactionContext>> {
        private SelectAnswer() {
        }

        public Optional<CompactionContext> answer(InvocationOnMock invocation) throws Throwable {
            return StatefulStoreMockMaker.this.selectCompaction();
        }
    }
}

