/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.CellArrayMap;
import org.apache.hadoop.hbase.regionserver.CellChunkMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={RegionServerTests.class, SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestCellFlatSet
extends TestCase {
    private static final int NUM_OF_CELLS = 4;
    private Cell[] ascCells;
    private CellArrayMap ascCbOnHeap;
    private Cell[] descCells;
    private CellArrayMap descCbOnHeap;
    private static final Configuration CONF = new Configuration();
    private KeyValue lowerOuterCell;
    private KeyValue upperOuterCell;
    private CellChunkMap ascCCM;
    private CellChunkMap descCCM;
    private CellChunkMap ascMultCCM;
    private CellChunkMap descMultCCM;
    private static ChunkCreator chunkCreator;

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{"SMALL_CHUNKS", "NORMAL_CHUNKS"};
    }

    public TestCellFlatSet(String chunkType) {
        long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)CONF, (boolean)false));
        if (chunkType == "NORMAL_CHUNKS") {
            chunkCreator = ChunkCreator.initialize((int)0x200000, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null);
            TestCellFlatSet.assertTrue((chunkCreator != null ? 1 : 0) != 0);
        } else {
            chunkCreator = ChunkCreator.initialize((int)64, (boolean)false, (long)globalMemStoreLimit, (float)0.2f, (float)0.0f, null);
            TestCellFlatSet.assertTrue((chunkCreator != null ? 1 : 0) != 0);
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        byte[] one = Bytes.toBytes((int)15);
        byte[] two = Bytes.toBytes((int)25);
        byte[] three = Bytes.toBytes((int)35);
        byte[] four = Bytes.toBytes((int)45);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)4);
        KeyValue kv1 = new KeyValue(one, f, q, 10L, v);
        KeyValue kv2 = new KeyValue(two, f, q, 20L, v);
        KeyValue kv3 = new KeyValue(three, f, q, 30L, v);
        KeyValue kv4 = new KeyValue(four, f, q, 40L, v);
        this.lowerOuterCell = new KeyValue(Bytes.toBytes((int)10), f, q, 10L, v);
        this.upperOuterCell = new KeyValue(Bytes.toBytes((int)50), f, q, 10L, v);
        this.ascCells = new Cell[]{kv1, kv2, kv3, kv4};
        this.ascCbOnHeap = new CellArrayMap((Comparator)CellComparatorImpl.COMPARATOR, this.ascCells, 0, 4, false);
        this.descCells = new Cell[]{kv4, kv3, kv2, kv1};
        this.descCbOnHeap = new CellArrayMap((Comparator)CellComparatorImpl.COMPARATOR, this.descCells, 0, 4, true);
        CONF.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        CONF.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 0.2f);
        ChunkCreator.chunkPoolDisabled = false;
        this.ascCCM = this.setUpCellChunkMap(true);
        this.descCCM = this.setUpCellChunkMap(false);
    }

    @Test
    public void testCellArrayMapAsc() throws Exception {
        CellSet cs = new CellSet((NavigableMap)this.ascCbOnHeap);
        this.testCellBlocks(cs);
        this.testIterators(cs);
    }

    @Test
    public void testCellChunkMap() throws Exception {
        CellSet cs = new CellSet((NavigableMap)this.ascCCM);
        this.testCellBlocks(cs);
        this.testIterators(cs);
        this.testSubSet(cs);
        cs = new CellSet((NavigableMap)this.descCCM);
        this.testSubSet(cs);
    }

    @Test
    public void testAsc() throws Exception {
        CellSet ascCs = new CellSet((NavigableMap)this.ascCbOnHeap);
        TestCellFlatSet.assertEquals((int)4, (int)ascCs.size());
        this.testSubSet(ascCs);
    }

    @Test
    public void testDesc() throws Exception {
        CellSet descCs = new CellSet((NavigableMap)this.descCbOnHeap);
        TestCellFlatSet.assertEquals((int)4, (int)descCs.size());
        this.testSubSet(descCs);
    }

    private void testSubSet(CellSet cs) throws Exception {
        int j;
        Iterator includeIter;
        Iterator excludeIter;
        int i;
        for (i = 0; i != this.ascCells.length; ++i) {
            NavigableSet excludeTail = cs.tailSet(this.ascCells[i], false);
            NavigableSet includeTail = cs.tailSet(this.ascCells[i], true);
            TestCellFlatSet.assertEquals((int)(this.ascCells.length - 1 - i), (int)excludeTail.size());
            TestCellFlatSet.assertEquals((int)(this.ascCells.length - i), (int)includeTail.size());
            excludeIter = excludeTail.iterator();
            includeIter = includeTail.iterator();
            for (j = 1 + i; j != this.ascCells.length; ++j) {
                TestCellFlatSet.assertEquals((boolean)true, (boolean)CellUtil.equals((Cell)((Cell)excludeIter.next()), (Cell)this.ascCells[j]));
            }
            for (j = i; j != this.ascCells.length; ++j) {
                TestCellFlatSet.assertEquals((boolean)true, (boolean)CellUtil.equals((Cell)((Cell)includeIter.next()), (Cell)this.ascCells[j]));
            }
        }
        TestCellFlatSet.assertEquals((int)4, (int)cs.tailSet((Cell)this.lowerOuterCell, false).size());
        TestCellFlatSet.assertEquals((int)0, (int)cs.tailSet((Cell)this.upperOuterCell, false).size());
        for (i = 0; i != this.ascCells.length; ++i) {
            NavigableSet excludeHead = cs.headSet(this.ascCells[i], false);
            NavigableSet includeHead = cs.headSet(this.ascCells[i], true);
            TestCellFlatSet.assertEquals((int)i, (int)excludeHead.size());
            TestCellFlatSet.assertEquals((int)(i + 1), (int)includeHead.size());
            excludeIter = excludeHead.iterator();
            includeIter = includeHead.iterator();
            for (j = 0; j != i; ++j) {
                TestCellFlatSet.assertEquals((boolean)true, (boolean)CellUtil.equals((Cell)((Cell)excludeIter.next()), (Cell)this.ascCells[j]));
            }
            for (j = 0; j != i + 1; ++j) {
                TestCellFlatSet.assertEquals((boolean)true, (boolean)CellUtil.equals((Cell)((Cell)includeIter.next()), (Cell)this.ascCells[j]));
            }
        }
        TestCellFlatSet.assertEquals((int)0, (int)cs.headSet((Cell)this.lowerOuterCell, false).size());
        TestCellFlatSet.assertEquals((int)4, (int)cs.headSet((Cell)this.upperOuterCell, false).size());
        NavigableMap sub = cs.getDelegatee().subMap(this.lowerOuterCell, true, this.upperOuterCell, true);
        TestCellFlatSet.assertEquals((int)4, (int)sub.size());
        Iterator iter = sub.values().iterator();
        for (int i2 = 0; i2 != this.ascCells.length; ++i2) {
            TestCellFlatSet.assertEquals((boolean)true, (boolean)CellUtil.equals((Cell)((Cell)iter.next()), (Cell)this.ascCells[i2]));
        }
    }

    private void testCellBlocks(CellSet cs) throws Exception {
        byte[] oneAndHalf = Bytes.toBytes((int)20);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)4);
        KeyValue outerCell = new KeyValue(oneAndHalf, f, q, 10L, v);
        TestCellFlatSet.assertEquals((int)4, (int)cs.size());
        TestCellFlatSet.assertFalse((boolean)cs.contains((Object)outerCell));
        TestCellFlatSet.assertTrue((boolean)cs.contains((Object)this.ascCells[0]));
        Cell first = cs.first();
        TestCellFlatSet.assertTrue((boolean)this.ascCells[0].equals(first));
        TestCellFlatSet.assertTrue((boolean)cs.contains((Object)this.ascCells[3]));
        Cell last = cs.last();
        TestCellFlatSet.assertTrue((boolean)this.ascCells[3].equals(last));
        SortedSet tail = cs.tailSet(this.ascCells[1]);
        TestCellFlatSet.assertEquals((int)3, (int)tail.size());
        SortedSet head = cs.headSet(this.ascCells[1]);
        TestCellFlatSet.assertEquals((int)1, (int)head.size());
        SortedSet tailOuter = cs.tailSet((Cell)outerCell);
        TestCellFlatSet.assertEquals((int)3, (int)tailOuter.size());
        Cell tailFirst = (Cell)tail.first();
        TestCellFlatSet.assertTrue((boolean)this.ascCells[1].equals(tailFirst));
        Cell tailLast = (Cell)tail.last();
        TestCellFlatSet.assertTrue((boolean)this.ascCells[3].equals(tailLast));
        Cell headFirst = (Cell)head.first();
        TestCellFlatSet.assertTrue((boolean)this.ascCells[0].equals(headFirst));
        Cell headLast = (Cell)head.last();
        TestCellFlatSet.assertTrue((boolean)this.ascCells[0].equals(headLast));
    }

    private void testIterators(CellSet cs) throws Exception {
        int count = 0;
        for (Cell kv : cs) {
            TestCellFlatSet.assertEquals((String)("\n\n-------------------------------------------------------------------\nComparing iteration number " + (count + 1) + " the returned cell: " + kv + ", the first Cell in the CellBlocksMap: " + this.ascCells[count] + ", and the same transformed to String: " + this.ascCells[count].toString() + "\n-------------------------------------------------------------------\n"), (Object)this.ascCells[count], (Object)kv);
            ++count;
        }
        TestCellFlatSet.assertEquals((int)4, (int)count);
        count = 0;
        Iterator i = cs.descendingIterator();
        while (i.hasNext()) {
            Cell kv;
            kv = (Cell)i.next();
            TestCellFlatSet.assertEquals((Object)this.ascCells[4 - (count + 1)], (Object)kv);
            ++count;
        }
        TestCellFlatSet.assertEquals((int)4, (int)count);
    }

    private CellChunkMap setUpCellChunkMap(boolean asc) {
        Cell[] cellArray;
        Chunk dataChunk = chunkCreator.getChunk();
        Chunk idxChunk = chunkCreator.getChunk();
        Chunk[] chunkArray = new Chunk[8];
        int chunkArrayIdx = 0;
        chunkArray[chunkArrayIdx++] = idxChunk;
        ByteBuffer idxBuffer = idxChunk.getData();
        ByteBuffer dataBuffer = dataChunk.getData();
        int dataOffset = 4;
        int idxOffset = 4;
        for (Cell kv : cellArray = asc ? this.ascCells : this.descCells) {
            if (dataOffset + KeyValueUtil.length((Cell)kv) > chunkCreator.getChunkSize()) {
                dataChunk = chunkCreator.getChunk();
                dataBuffer = dataChunk.getData();
                dataOffset = 4;
            }
            int dataStartOfset = dataOffset;
            dataOffset = KeyValueUtil.appendTo((Cell)kv, (ByteBuffer)dataBuffer, (int)dataOffset, (boolean)false);
            if (idxOffset + ClassSize.CELL_CHUNK_MAP_ENTRY > chunkCreator.getChunkSize()) {
                idxChunk = chunkCreator.getChunk();
                idxBuffer = idxChunk.getData();
                idxOffset = 4;
                chunkArray[chunkArrayIdx++] = idxChunk;
            }
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)dataChunk.getId());
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)dataStartOfset);
            idxOffset = ByteBufferUtils.putInt((ByteBuffer)idxBuffer, (int)idxOffset, (int)KeyValueUtil.length((Cell)kv));
            idxOffset = ByteBufferUtils.putLong((ByteBuffer)idxBuffer, (int)idxOffset, (long)kv.getSequenceId());
        }
        return new CellChunkMap((Comparator)CellComparatorImpl.COMPARATOR, chunkArray, 0, 4, !asc);
    }
}

