/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestGetClosestAtOrBefore {
    @Rule
    public TestName testName = new TestName();
    private static final Log LOG = LogFactory.getLog(TestGetClosestAtOrBefore.class);
    private static final byte[] T00 = Bytes.toBytes((String)"000");
    private static final byte[] T10 = Bytes.toBytes((String)"010");
    private static final byte[] T11 = Bytes.toBytes((String)"011");
    private static final byte[] T12 = Bytes.toBytes((String)"012");
    private static final byte[] T20 = Bytes.toBytes((String)"020");
    private static final byte[] T30 = Bytes.toBytes((String)"030");
    private static final byte[] T31 = Bytes.toBytes((String)"031");
    private static final byte[] T35 = Bytes.toBytes((String)"035");
    private static final byte[] T40 = Bytes.toBytes((String)"040");
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration conf = UTIL.getConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsingMetaAndBinary() throws IOException {
        FileSystem filesystem = FileSystem.get((Configuration)conf);
        Path rootdir = UTIL.getDataTestDirOnTestFS();
        TableDescriptorBuilder metaBuilder = UTIL.getMetaTableDescriptorBuilder().setMemStoreFlushSize(0x4000000L);
        HRegion mr = HBaseTestingUtility.createRegionAndWAL((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO, rootdir, conf, metaBuilder.build());
        try {
            for (char c = 'A'; c < 'D'; c = (char)(c + '\u0001')) {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)("" + c)));
                int last = 128;
                int interval = 2;
                for (int i = 0; i <= 128; i += 2) {
                    HRegionInfo hri = new HRegionInfo(htd.getTableName(), i == 0 ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes((short)((byte)i)), i == 128 ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes((int)((byte)i + 2)));
                    Put put = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)hri);
                    put.setDurability(Durability.SKIP_WAL);
                    mr.put(put);
                }
            }
            try (HRegion.RegionScannerImpl s = mr.getScanner(new Scan());){
                ArrayList keys = new ArrayList();
                while (s.next(keys)) {
                    LOG.info(keys);
                    keys.clear();
                }
            }
            this.findRow((Region)mr, 'C', 44, 44);
            this.findRow((Region)mr, 'C', 45, 44);
            this.findRow((Region)mr, 'C', 46, 46);
            this.findRow((Region)mr, 'C', 43, 42);
            mr.flush(true);
            this.findRow((Region)mr, 'C', 44, 44);
            this.findRow((Region)mr, 'C', 45, 44);
            this.findRow((Region)mr, 'C', 46, 46);
            this.findRow((Region)mr, 'C', 43, 42);
            byte[] firstRowInC = HRegionInfo.createRegionName((TableName)TableName.valueOf((String)"C"), (byte[])HConstants.EMPTY_BYTE_ARRAY, (String)"00000000000000", (boolean)false);
            Scan scan = new Scan(firstRowInC);
            s = mr.getScanner(scan);
            try {
                ArrayList keys = new ArrayList();
                while (s.next(keys)) {
                    mr.delete(new Delete(CellUtil.cloneRow((Cell)((Cell)keys.get(0)))));
                    keys.clear();
                }
            }
            finally {
                s.close();
            }
            this.findRow((Region)mr, 'C', 44, -1);
            this.findRow((Region)mr, 'C', 45, -1);
            this.findRow((Region)mr, 'C', 46, -1);
            this.findRow((Region)mr, 'C', 43, -1);
            mr.flush(true);
            this.findRow((Region)mr, 'C', 44, -1);
            this.findRow((Region)mr, 'C', 45, -1);
            this.findRow((Region)mr, 'C', 46, -1);
            this.findRow((Region)mr, 'C', 43, -1);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(mr);
        }
    }

    private byte[] findRow(Region mr, char table, int rowToFind, int answer) throws IOException {
        TableName tableb = TableName.valueOf((String)("" + table));
        byte[] tofindBytes = Bytes.toBytes((short)((short)rowToFind));
        byte[] metaKey = HRegionInfo.createRegionName((TableName)tableb, (byte[])tofindBytes, (String)"99999999999999", (boolean)false);
        LOG.info((Object)("find=" + new String(metaKey)));
        Result r = UTIL.getClosestRowBefore(mr, metaKey, HConstants.CATALOG_FAMILY);
        if (answer == -1) {
            Assert.assertNull((Object)r);
            return null;
        }
        Assert.assertTrue((Bytes.compareTo((byte[])Bytes.toBytes((short)((short)answer)), (byte[])this.extractRowFromMetaRow(r.getRow())) == 0 ? 1 : 0) != 0);
        return r.getRow();
    }

    private byte[] extractRowFromMetaRow(byte[] b) {
        int firstDelimiter = Bytes.searchDelimiterIndex((byte[])b, (int)0, (int)b.length, (int)44);
        int lastDelimiter = Bytes.searchDelimiterIndexInReverse((byte[])b, (int)0, (int)b.length, (int)44);
        int length = lastDelimiter - firstDelimiter - 1;
        byte[] row = new byte[length];
        System.arraycopy(b, firstDelimiter + 1, row, 0, length);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosestRowBefore3() throws IOException {
        HRegion region = null;
        byte[] c0 = HBaseTestingUtility.COLUMNS[0];
        byte[] c1 = HBaseTestingUtility.COLUMNS[1];
        try {
            TableName tn = TableName.valueOf((String)this.testName.getMethodName());
            HTableDescriptor htd = UTIL.createTableDescriptor(tn);
            region = UTIL.createLocalHRegion((TableDescriptor)htd, null, null);
            Put p = new Put(T00);
            p.addColumn(c0, c0, T00);
            region.put(p);
            p = new Put(T10);
            p.addColumn(c0, c0, T10);
            region.put(p);
            p = new Put(T20);
            p.addColumn(c0, c0, T20);
            region.put(p);
            Result r = UTIL.getClosestRowBefore((Region)region, T20, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T20, (byte[])r.getRow()));
            Delete d = new Delete(T20);
            d.addColumn(c0, c0);
            region.delete(d);
            r = UTIL.getClosestRowBefore((Region)region, T20, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            p = new Put(T30);
            p.addColumn(c0, c0, T30);
            region.put(p);
            r = UTIL.getClosestRowBefore((Region)region, T30, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T30, (byte[])r.getRow()));
            d = new Delete(T30);
            d.addColumn(c0, c0);
            region.delete(d);
            r = UTIL.getClosestRowBefore((Region)region, T30, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            r = UTIL.getClosestRowBefore((Region)region, T31, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            region.flush(true);
            r = UTIL.getClosestRowBefore((Region)region, T30, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            r = UTIL.getClosestRowBefore((Region)region, T31, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            p = new Put(T20);
            p.addColumn(c1, c1, T20);
            region.put(p);
            r = UTIL.getClosestRowBefore((Region)region, T30, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            r = UTIL.getClosestRowBefore((Region)region, T31, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            region.flush(true);
            r = UTIL.getClosestRowBefore((Region)region, T30, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            r = UTIL.getClosestRowBefore((Region)region, T31, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            d = new Delete(T20);
            d.addColumn(c1, c1);
            region.delete(d);
            r = UTIL.getClosestRowBefore((Region)region, T30, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            r = UTIL.getClosestRowBefore((Region)region, T31, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            region.flush(true);
            r = UTIL.getClosestRowBefore((Region)region, T31, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T10, (byte[])r.getRow()));
            p = new Put(T11);
            p.addColumn(c0, c0, T11);
            region.put(p);
            d = new Delete(T10);
            d.addColumn(c1, c1);
            r = UTIL.getClosestRowBefore((Region)region, T12, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T11, (byte[])r.getRow()));
        }
        finally {
            if (region != null) {
                try {
                    WAL wal = region.getWAL();
                    region.close();
                    wal.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosestRowBefore2() throws IOException {
        HRegion region = null;
        byte[] c0 = HBaseTestingUtility.COLUMNS[0];
        try {
            TableName tn = TableName.valueOf((String)this.testName.getMethodName());
            HTableDescriptor htd = UTIL.createTableDescriptor(tn);
            region = UTIL.createLocalHRegion((TableDescriptor)htd, null, null);
            Put p = new Put(T10);
            p.addColumn(c0, c0, T10);
            region.put(p);
            p = new Put(T30);
            p.addColumn(c0, c0, T30);
            region.put(p);
            p = new Put(T40);
            p.addColumn(c0, c0, T40);
            region.put(p);
            Result r = UTIL.getClosestRowBefore((Region)region, T35, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T30, (byte[])r.getRow()));
            region.flush(true);
            r = UTIL.getClosestRowBefore((Region)region, T35, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T30, (byte[])r.getRow()));
            p = new Put(T20);
            p.addColumn(c0, c0, T20);
            region.put(p);
            r = UTIL.getClosestRowBefore((Region)region, T35, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T30, (byte[])r.getRow()));
            region.flush(true);
            r = UTIL.getClosestRowBefore((Region)region, T35, c0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])T30, (byte[])r.getRow()));
        }
        finally {
            if (region != null) {
                try {
                    WAL wal = region.getWAL();
                    region.close();
                    wal.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

