/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.TestHRegion;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestHRegionWithInMemoryFlush
extends TestHRegion {
    private static final Log LOG = LogFactory.getLog(TestHRegionWithInMemoryFlush.class);
    @ClassRule
    public static final TestRule timeout = CategoryBasedTimeout.forClass(TestHRegionWithInMemoryFlush.class);

    @Override
    public HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        boolean[] inMemory = new boolean[families.length];
        for (int i = 0; i < inMemory.length; ++i) {
            inMemory[i] = true;
        }
        return TEST_UTIL.createLocalHRegionWithInMemoryFlags(tableName, startKey, stopKey, isReadOnly, durability, wal, inMemory, families);
    }
}

