/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestKeepDeletes {
    HBaseTestingUtility hbu = HBaseTestingUtility.createLocalHTU();
    private final byte[] T0 = Bytes.toBytes((String)"0");
    private final byte[] T1 = Bytes.toBytes((String)"1");
    private final byte[] T2 = Bytes.toBytes((String)"2");
    private final byte[] T3 = Bytes.toBytes((String)"3");
    private final byte[] T4 = Bytes.toBytes((String)"4");
    private final byte[] T5 = Bytes.toBytes((String)"5");
    private final byte[] T6 = Bytes.toBytes((String)"6");
    private final byte[] c0 = HBaseTestingUtility.COLUMNS[0];
    private final byte[] c1 = HBaseTestingUtility.COLUMNS[1];
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testBasicScenario() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 3, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts + 1L);
        p.addColumn(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts + 2L);
        p.addColumn(this.c0, this.c0, this.T3);
        region.put(p);
        p = new Put(this.T1, ts + 4L);
        p.addColumn(this.c0, this.c0, this.T4);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 2L);
        region.delete(d);
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        Get g = new Get(this.T1);
        g.setMaxVersions();
        g.setTimeRange(0L, ts + 2L);
        Result r = region.get(g);
        this.checkResult(r, this.c0, this.c0, this.T2, this.T1);
        region.flush(true);
        r = region.get(g);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T2});
        region.compact(true);
        region.compact(true);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        r = region.get(g);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T2});
        g.setTimeRange(0L, ts + 4L);
        r = region.get(g);
        Assert.assertTrue((boolean)r.isEmpty());
        p = new Put(this.T1, ts + 5L);
        p.addColumn(this.c0, this.c0, this.T5);
        region.put(p);
        p = new Put(this.T1, ts + 6L);
        p.addColumn(this.c0, this.c0, this.T6);
        region.put(p);
        p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        r = region.get(g);
        Assert.assertTrue((boolean)r.isEmpty());
        region.flush(true);
        region.compact(true);
        region.compact(true);
        region.put(p);
        r = region.get(g);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T1});
        Assert.assertEquals((long)0L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testRawScanWithoutKeepingDeletes() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 3, Integer.MAX_VALUE, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts);
        region.delete(d);
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        HRegion.RegionScannerImpl scan = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        scan.next(kvs);
        Assert.assertEquals((long)2L, (long)kvs.size());
        region.flush(true);
        region.compact(true);
        s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        scan = region.getScanner(s);
        kvs = new ArrayList();
        scan.next(kvs);
        Assert.assertTrue((boolean)kvs.isEmpty());
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testWithoutKeepingDeletes() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 3, Integer.MAX_VALUE, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        Get gOne = new Get(this.T1);
        gOne.setMaxVersions();
        gOne.setTimeRange(0L, ts + 1L);
        Result rOne = region.get(gOne);
        Assert.assertFalse((boolean)rOne.isEmpty());
        Delete d = new Delete(this.T1, ts + 2L);
        d.addColumn(this.c0, this.c0, ts);
        region.delete(d);
        Get g = new Get(this.T1);
        g.setMaxVersions();
        g.setTimeRange(0L, ts + 1L);
        Result r = region.get(g);
        Assert.assertTrue((boolean)r.isEmpty());
        Scan s = new Scan();
        s.setMaxVersions();
        s.setTimeRange(0L, ts + 1L);
        HRegion.RegionScannerImpl scanner = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        while (scanner.next(kvs)) {
        }
        Assert.assertTrue((boolean)kvs.isEmpty());
        region.flush(true);
        region.compact(false);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)0L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testRawScanWithColumns() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 3, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        s.addColumn(this.c0, this.c0);
        try {
            region.getScanner(s);
            Assert.fail((String)"raw scanner with columns should have failed");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        HBaseTestingUtility.closeRegionAndWAL((Region)region);
    }

    @Test
    public void testRawScan() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 3, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts + 2L);
        p.addColumn(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts + 4L);
        p.addColumn(this.c0, this.c0, this.T3);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 1L);
        region.delete(d);
        d = new Delete(this.T1, ts + 2L);
        d.addColumn(this.c0, this.c0, ts + 2L);
        region.delete(d);
        d = new Delete(this.T1, ts + 3L);
        d.addColumns(this.c0, this.c0, ts + 3L);
        region.delete(d);
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        RegionScanner scan = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        scan.next(kvs);
        Assert.assertEquals((long)8L, (long)kvs.size());
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)((Cell)kvs.get(0))));
        Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(1))), (byte[])this.T3);
        Assert.assertTrue((boolean)CellUtil.isDelete((Cell)((Cell)kvs.get(2))));
        Assert.assertTrue((boolean)CellUtil.isDelete((Cell)((Cell)kvs.get(3))));
        Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(4))), (byte[])this.T2);
        Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(5))), (byte[])this.T1);
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)((Cell)kvs.get(6))));
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)((Cell)kvs.get(7))));
        s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        s.setTimeRange(0L, 1L);
        scan = region.getScanner(s);
        kvs = new ArrayList();
        scan.next(kvs);
        Assert.assertTrue((boolean)kvs.isEmpty());
        s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        s.setTimeRange(0L, ts + 2L);
        scan = region.getScanner(s);
        kvs = new ArrayList();
        scan.next(kvs);
        Assert.assertEquals((long)4L, (long)kvs.size());
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)((Cell)kvs.get(0))));
        Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(1))), (byte[])this.T1);
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)((Cell)kvs.get(2))));
        Assert.assertTrue((boolean)PrivateCellUtil.isDeleteFamily((Cell)((Cell)kvs.get(3))));
        s = new Scan();
        s.setRaw(true);
        s.setMaxVersions();
        s.setTimeRange(ts + 3L, ts + 5L);
        scan = region.getScanner(s);
        kvs = new ArrayList();
        scan.next(kvs);
        Assert.assertEquals((long)2L, (long)kvs.size());
        Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(0))), (byte[])this.T3);
        Assert.assertTrue((boolean)CellUtil.isDelete((Cell)((Cell)kvs.get(1))));
        HBaseTestingUtility.closeRegionAndWAL((Region)region);
    }

    @Test
    public void testDeleteMarkerExpirationEmptyStore() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 1, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Delete d = new Delete(this.T1, ts);
        d.addColumns(this.c0, this.c0, ts);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addFamily(this.c0);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts + 1L);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts + 2L);
        region.delete(d);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.flush(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.compact(false);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)0L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testDeleteMarkerExpiration() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 1, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 10L);
        p.addColumn(this.c1, this.c0, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts);
        d.addColumns(this.c0, this.c0, ts);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addFamily(this.c0, ts);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts + 1L);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts + 2L);
        region.delete(d);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.flush(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.compact(false);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 3L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        region.flush(true);
        region.compact(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)0L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testWithOldRow() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 1, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T2, ts - 10L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts);
        d.addColumns(this.c0, this.c0, ts);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addFamily(this.c0, ts);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts + 1L);
        region.delete(d);
        d = new Delete(this.T1, ts);
        d.addColumn(this.c0, this.c0, ts + 2L);
        region.delete(d);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.flush(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.compact(false);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 3L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        region.flush(true);
        region.compact(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 4L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        region.compact(true);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testRanges() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 3, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        p.addColumn(this.c0, this.c1, this.T1);
        p.addColumn(this.c1, this.c0, this.T1);
        p.addColumn(this.c1, this.c1, this.T1);
        region.put(p);
        p = new Put(this.T2, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        p.addColumn(this.c0, this.c1, this.T1);
        p.addColumn(this.c1, this.c0, this.T1);
        p.addColumn(this.c1, this.c1, this.T1);
        region.put(p);
        p = new Put(this.T1, ts + 1L);
        p.addColumn(this.c0, this.c0, this.T2);
        p.addColumn(this.c0, this.c1, this.T2);
        p.addColumn(this.c1, this.c0, this.T2);
        p.addColumn(this.c1, this.c1, this.T2);
        region.put(p);
        p = new Put(this.T2, ts + 1L);
        p.addColumn(this.c0, this.c0, this.T2);
        p.addColumn(this.c0, this.c1, this.T2);
        p.addColumn(this.c1, this.c0, this.T2);
        p.addColumn(this.c1, this.c1, this.T2);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 2L);
        d.addColumns(this.c0, this.c0, ts + 2L);
        region.delete(d);
        d = new Delete(this.T1, ts + 2L);
        d.addFamily(this.c1, ts + 2L);
        region.delete(d);
        d = new Delete(this.T2, ts + 2L);
        d.addFamily(this.c0, ts + 2L);
        region.delete(d);
        d = new Delete(this.T1, ts - 10L);
        d.addFamily(this.c1, ts - 10L);
        region.delete(d);
        this.checkGet((Region)region, this.T1, this.c0, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T1, this.c0, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T1, this.c1, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T1, this.c1, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T2, this.c0, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T2, this.c0, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T2, this.c1, this.c0, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T2, this.c1, this.c1, ts + 2L, this.T2, this.T1);
        this.checkGet((Region)region, this.T1, this.c0, this.c0, ts + 3L, new byte[0][]);
        this.checkGet((Region)region, this.T1, this.c0, this.c1, ts + 3L, this.T2, this.T1);
        this.checkGet((Region)region, this.T1, this.c1, this.c0, ts + 3L, new byte[0][]);
        this.checkGet((Region)region, this.T1, this.c1, this.c1, ts + 3L, new byte[0][]);
        this.checkGet((Region)region, this.T2, this.c0, this.c0, ts + 3L, new byte[0][]);
        this.checkGet((Region)region, this.T2, this.c0, this.c1, ts + 3L, new byte[0][]);
        this.checkGet((Region)region, this.T2, this.c1, this.c0, ts + 3L, this.T2, this.T1);
        this.checkGet((Region)region, this.T2, this.c1, this.c1, ts + 3L, this.T2, this.T1);
        HBaseTestingUtility.closeRegionAndWAL((Region)region);
    }

    @Test
    public void testDeleteMarkerVersioning() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 1, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 10L);
        p.addColumn(this.c0, this.c1, this.T1);
        region.put(p);
        Delete d = new Delete(this.T1, ts);
        d.addColumns(this.c0, this.c0, ts);
        region.delete(d);
        d = new Delete(this.T1, ts + 1L);
        d.addColumn(this.c0, this.c0, ts + 1L);
        region.delete(d);
        d = new Delete(this.T1, ts + 3L);
        d.addColumn(this.c0, this.c0, ts + 3L);
        region.delete(d);
        region.flush(true);
        region.compact(true);
        region.compact(true);
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 2L);
        p.addColumn(this.c0, this.c0, this.T2);
        region.put(p);
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 3L);
        p.addColumn(this.c0, this.c0, this.T3);
        region.put(p);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        region.flush(true);
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        p = new Put(this.T1, ts + 4L);
        p.addColumn(this.c0, this.c0, this.T4);
        region.put(p);
        region.flush(true);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        region.compact(true);
        Assert.assertEquals((long)1L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    public void testWithMixedCFs() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 0, 1, Integer.MAX_VALUE, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime();
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T1);
        p.addColumn(this.c0, this.c1, this.T1);
        p.addColumn(this.c1, this.c0, this.T1);
        p.addColumn(this.c1, this.c1, this.T1);
        region.put(p);
        p = new Put(this.T2, ts + 1L);
        p.addColumn(this.c0, this.c0, this.T2);
        p.addColumn(this.c0, this.c1, this.T2);
        p.addColumn(this.c1, this.c0, this.T2);
        p.addColumn(this.c1, this.c1, this.T2);
        region.put(p);
        Delete d = new Delete(this.T1, ts + 1L);
        region.delete(d);
        d = new Delete(this.T2, ts + 2L);
        region.delete(d);
        Scan s = new Scan(this.T1);
        s.setTimeRange(0L, ts + 1L);
        RegionScanner scanner = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        scanner.next(kvs);
        Assert.assertEquals((long)4L, (long)kvs.size());
        scanner.close();
        s = new Scan(this.T2);
        s.setTimeRange(0L, ts + 2L);
        scanner = region.getScanner(s);
        kvs = new ArrayList();
        scanner.next(kvs);
        Assert.assertEquals((long)4L, (long)kvs.size());
        scanner.close();
        HBaseTestingUtility.closeRegionAndWAL((Region)region);
    }

    @Test
    public void testWithMinVersions() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 3, 1000, 1, KeepDeletedCells.TRUE);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T3);
        region.put(p);
        p = new Put(this.T1, ts - 1L);
        p.addColumn(this.c0, this.c0, this.T2);
        region.put(p);
        p = new Put(this.T1, ts - 3L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        p = new Put(this.T1, ts - 4L);
        p.addColumn(this.c0, this.c0, this.T0);
        region.put(p);
        Delete d = new Delete(this.T1, ts - 1L);
        region.delete(d);
        d = new Delete(this.T1, ts - 2L);
        d.addColumns(this.c0, this.c0, ts - 1L);
        region.delete(d);
        Get g = new Get(this.T1);
        g.setMaxVersions();
        g.setTimeRange(0L, ts - 2L);
        Result r = region.get(g);
        this.checkResult(r, this.c0, this.c0, this.T1, this.T0);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        region.flush(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        r = region.get(g);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T1});
        p = new Put(this.T1, ts + 1L);
        p.addColumn(this.c0, this.c0, this.T4);
        region.put(p);
        region.flush(true);
        Assert.assertEquals((long)4L, (long)this.countDeleteMarkers(region));
        r = region.get(g);
        this.checkResult(r, this.c0, this.c0, new byte[][]{this.T1});
        p = new Put(this.T1, ts + 2L);
        p.addColumn(this.c0, this.c0, this.T5);
        region.put(p);
        region.flush(true);
        region.compact(true);
        Assert.assertEquals((long)2L, (long)this.countDeleteMarkers(region));
        region.compact(true);
        Assert.assertEquals((long)0L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    @Test
    public void testWithTTL() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 1, 1000, 1, KeepDeletedCells.TTL);
        HRegion region = this.hbu.createLocalHRegion((TableDescriptor)htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        Put p = new Put(this.T1, ts);
        p.addColumn(this.c0, this.c0, this.T3);
        region.put(p);
        p = new Put(this.T2, ts - 10L);
        p.addColumn(this.c0, this.c0, this.T1);
        region.put(p);
        this.checkGet((Region)region, this.T1, this.c0, this.c0, ts + 1L, new byte[][]{this.T3});
        Delete d = new Delete(this.T1, ts + 2L);
        region.delete(d);
        this.checkGet((Region)region, this.T1, this.c0, this.c0, ts + 1L, new byte[][]{this.T3});
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        region.flush(true);
        Assert.assertEquals((long)3L, (long)this.countDeleteMarkers(region));
        this.checkGet((Region)region, this.T1, this.c0, this.c0, ts + 1L, new byte[0][]);
        region.compact(true);
        Assert.assertEquals((long)0L, (long)this.countDeleteMarkers(region));
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    private void checkGet(Region region, byte[] row, byte[] fam, byte[] col, long time, byte[] ... vals) throws IOException {
        Get g = new Get(row);
        g.addColumn(fam, col);
        g.setMaxVersions();
        g.setTimeRange(0L, time);
        Result r = region.get(g);
        this.checkResult(r, fam, col, vals);
    }

    private int countDeleteMarkers(HRegion region) throws IOException {
        boolean hasMore;
        Scan s = new Scan();
        s.setRaw(true);
        s.setMaxVersions(((HStore)region.getStores().iterator().next()).getScanInfo().getMaxVersions());
        HRegion.RegionScannerImpl scan = region.getScanner(s);
        ArrayList kvs = new ArrayList();
        int res = 0;
        do {
            hasMore = scan.next(kvs);
            for (Cell kv : kvs) {
                if (!CellUtil.isDelete((Cell)kv)) continue;
                ++res;
            }
            kvs.clear();
        } while (hasMore);
        scan.close();
        return res;
    }

    private void checkResult(Result r, byte[] fam, byte[] col, byte[] ... vals) {
        Assert.assertEquals((long)r.size(), (long)vals.length);
        List kvs = r.getColumnCells(fam, col);
        Assert.assertEquals((long)kvs.size(), (long)vals.length);
        for (int i = 0; i < vals.length; ++i) {
            Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)((Cell)kvs.get(i))), (byte[])vals[i]);
        }
    }
}

